

import java.util.Arrays;

import jp.sourceforge.sos.cytoq.main.SegmentationPlugin;
import sos.image.ImageInfo;
import sos.math.Clustering;
import sos.math.MathVector;
import sos.panel.JGenericPanel;
import sos.process.NeighborFrame;
import sos.util.MinMaxDouble;
import sos.util.Sets;

/**
 * The abstract class for clastering algorithms.
 * @author Scientific Open Source projects (Gaku Tanaka)
 */
public class MarkovMeans extends Clustering implements SegmentationPlugin{
	
	private ImageInfo imi;
	double beta = 0.0;
	double betaDelta;
	double[] neighborBeta;
	
	double sentinel;
	
	double[][] preConvolutedUnit;
	int[] oldLabel;
	double[][] oldUnitMean;
	
	public MarkovMeans(){
		JGenericPanel panel = new JGenericPanel();
		panel.addNumericField("beta ", 1.0, 1);
		optionPanel = panel;
	}
	
	public void calculate() {
		
		// calculate new unitMean of the clusters
		int[] table = imi.getPixelColorTable();
		int[] nSameLabeledNeighbor = new int[nUnit];
		double[] preP = new double[nUnit];
		double[] inp;
		double sumP;
		NeighborFrame nf = imi.getNeighborFrame();
		nf.set8();
		MinMaxDouble mmd = new MinMaxDouble();
		
		initCalculation();
		for (int pn=0; pn<imi.getImageSize(); pn++){
			int[] neighbors = nf.getExist(pn);
			// sum up neighbor label
			Arrays.fill(nSameLabeledNeighbor, 0);
			for (int n=0; n<neighbors.length; n++){
				nSameLabeledNeighbor[imi.getPixelsLabel(pn+neighbors[n])]++;
			}
			// normalize beta
			sumP = 0.0;
			for (int un=0; un<nUnit; un++){
				preP[un] = neighborBeta[nSameLabeledNeighbor[un]];
				sumP += preP[un];
			}
			for (int un=0; un<nUnit; un++){
				preP[un] /= sumP;
			}
			// find the minimum norm
			inp = inputD[table[pn]];
			mmd.setInit(Math.sqrt(MathVector.norm(inp,units[0].mean))/preP[0]);
			for (int un=1; un<nUnit; un++){
				mmd.compareMin(Math.sqrt(MathVector.norm(inp,units[un].mean))/preP[un]);
			}
			imi.setPixelsLabel(pn,mmd.getIndex());
			for (int d=0; d<dim; d++){
				units[mmd.getIndex()].cumInput[d] += inp[d];
			}
			units[mmd.getIndex()].nBelong ++;
		}
		calcMean(true);
		
		imi.setClusterFromLabel(nUnit,cluster);
	}
	
	public boolean isConvoluted() {
		return (evaluatedValue<desiredValue);
	}
	
	private void setClusterAndLabel(){
		for (int in=0; in<nInput; in++){
			cluster[in] = Sets.findNearest(getMeanD(),inputD[in]);
		}
		int[] table = imi.getPixelColorTable();
		for (int pn=0; pn<imi.getImageSize(); pn++){
			imi.setPixelsLabel(pn, cluster[table[pn]]);
		}
	}
	
	public void setParameters(ImageInfo imi) {
		this.imi = imi;
		moveUnitsToNearestInputs();
		setClusterAndLabel();
		if (optionPanel!=null){
			beta = ((JGenericPanel)optionPanel).getFieldNumber(0);
			betaDelta = beta/10.0;
			NeighborFrame nf = imi.getNeighborFrame();
			nf.set8();
			neighborBeta = new double[nf.getNumber()+1];
			setBetaArray();
			
			oldLabel = new int[imi.getImageSize()];
			oldUnitMean = new double[nUnit][dim];
			backup();
			
			sentinel = Double.NEGATIVE_INFINITY;
		}
	}
	
	private void setBetaArray(){
		for (int i=0; i<neighborBeta.length; i++){
			neighborBeta[i] = Math.exp(i*beta);
		}
	}
	
	private void backup(){
		// reserve the labels
		for (int pn=0; pn<imi.getImageSize(); pn++){
			oldLabel[pn] = imi.getPixelsLabel(pn);
		}
		// reserve the means of units
		for (int i=0; i<oldUnitMean.length; i++){
			double[] current = getMeanD(i);
			System.arraycopy(current, 0, oldUnitMean[i], 0, dim);
		}
	}
	
	public void setPixelsLabel(ImageInfo imi) {
	}
}