
import jp.sourceforge.sos.cytoq.main.SegmentationPlugin;
import sos.image.ImageInfo;
import sos.math.Clustering;
import sos.math.MathVector;
import sos.panel.JGenericPanel;

/**
 * The abstract class for clastering algorithms.
 * @author Scientific Open Source projects (Gaku Tanaka)
 */
public class KMeans extends Clustering implements SegmentationPlugin{
	private int[] histogram;
	
	public KMeans(){
		String[] colorType = new String[]{"full color", "all pixels"};
		JGenericPanel panel = new JGenericPanel();
		panel.addChoice("sampling", colorType, 0);
		optionPanel = panel;
	}
	
	void doHCM(){
		for (int in=0; in<nInput; in++){
			MathVector.add(units[cluster[in]].cumInput,inputD[in]);
			units[cluster[in]].nBelong++;
		}
	}
	
	void doHistogramHCM(){
		for (int in=0; in<nInput; in++){
			for (int d=0; d<dim; d++){
				units[cluster[in]].cumInput[d] += inputD[in][d]*histogram[in];
			}
			units[cluster[in]].nBelong += histogram[in];
		}
	}
	
	void calculate(boolean saveUnit){
		initCalculation();
		findNearestMean(inputD);
		if (histogram==null){
			doHCM();
		}else{
			doHistogramHCM();
		}	
		calcMean(saveUnit);
	}
	
	public void calculate() {
		calculate(true);
	}
	
	public boolean isConvoluted() {
		return (evaluatedValue<desiredValue)?true:false;
	}
	
	public void setParameters(ImageInfo imi) {
		int index = ((JGenericPanel)optionPanel).getChoiceIndex(0);
		histogram = (index==0)?null:imi.getHistogram();
	}

	public void setPixelsLabel(ImageInfo imi) {
		imi.setPixelsLabel(cluster);
	}
	
}