package jp.sourceforge.sos.cytoq.start;

import jp.sourceforge.sos.cytoq.analysis.ControlAnalysis;
import jp.sourceforge.sos.cytoq.analysis.process.ControlProcess;
import jp.sourceforge.sos.cytoq.analysis.process.algorithm.ControlAlgorithm;
import jp.sourceforge.sos.cytoq.analysis.resultData.ControlResultData;
import jp.sourceforge.sos.cytoq.analysis.resultData.equation.ControlEquation;
import jp.sourceforge.sos.cytoq.color.ControlColor;
import jp.sourceforge.sos.cytoq.color.imageColor.ControlImageColor;
import jp.sourceforge.sos.cytoq.main.ControlMain;

public class Builder {

	public Builder() {
		ControlMain control = new ControlMain();

		ControlImageColor controlImageColor = new ControlImageColor(control);
		ControlColor controlColor = new ControlColor(controlImageColor);
		ControlAnalysis controlAnalysis = new ControlAnalysis(controlColor);
		new ControlProcess(controlAnalysis);
		new ControlAlgorithm(controlAnalysis);

		ControlResultData controlResultData = new ControlResultData(control);
		new ControlEquation(controlResultData);

		control.init();
		controlColor.init();
		controlImageColor.init();
	}

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				new Builder();
			}
		});
	}

}
