package jp.sourceforge.sos.cytoq.main;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;

@SuppressWarnings("serial")
public class ViewMenu extends JMenu implements IPACPresentation{

	private JMenuItem jMenuItemSave = null;
	private JMenuItem jMenuItemClear = null;
	
	private ModelMain modelMain;

	public ViewMenu() {
		super();
		initialize();
		add(getJMenuItemSave());
		add(getJMenuItemClear());
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        this.setText("Result");
        this.add(getJMenuItemSave());
        this.add(getJMenuItemClear());
	}

	/**
	 * This method initializes jMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemSave() {
		if (jMenuItemSave==null) {
			jMenuItemSave = new JMenuItem();
			jMenuItemSave.setText("Save...");
			jMenuItemSave.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					modelMain.save();				}
			});
		}
		return jMenuItemSave;
	}

	/**
	 * This method initializes jMenuItem1	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemClear() {
		if (jMenuItemClear==null) {
			jMenuItemClear = new JMenuItem();
			jMenuItemClear.setText("Clear");
			jMenuItemClear.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					modelMain.clear();				}
			});
		}
		return jMenuItemClear;
	}

	public void setAbstraction(IPACAbstraction abstraction) {
		modelMain = (ModelMain)abstraction;
	}
}
