package jp.sourceforge.sos.cytoq.main;

import javax.swing.JScrollPane;
import javax.swing.JTable;

import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;

@SuppressWarnings("serial")
class ViewHandlePanel extends JScrollPane implements IPACPresentation {

	private JTable		jTable	= null;

	ViewHandlePanel() {
		super();
		initialize();
		setSize(new java.awt.Dimension(200, 200));
	}
	
	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        this.setPreferredSize(new java.awt.Dimension(453,150));
        this.setViewportView(getJTableResultData());
			
	}

	public String toString(){
		return "RESULT TABLE";
	}

	/**
	 * This method initializes jTable
	 * 
	 * @return javax.swing.JTable
	 */
	private JTable getJTableResultData() {
		if (jTable==null) {
			jTable = new JTable();
		}
		return jTable;
	}

	public void setAbstraction(IPACAbstraction abstraction) {
		ModelMain model = (ModelMain)abstraction;
		getJTableResultData().setModel(model.getTableModel());
		setViewportView(getJTableResultData());
	}

}
