/*
 * ViewFrameMain.java
 *
 * Created on 2004/12/05, 18:05
 */

package jp.sourceforge.sos.cytoq.main;

import java.awt.BorderLayout;

import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;
import sos.panel.JHandlePanel;

/**
 * @author   Gaku Tanaka
 */
@SuppressWarnings("serial")
public class ViewFrameMain extends javax.swing.JFrame implements IPACPresentation{
	private static ViewFrameMain instance = null;

	/** Creates new form CytoQViewer */
	private ViewFrameMain() {
		initComponents();
	}
	
	public void addToMenuBar(JMenu menu){
		jMenuBar.add(menu);
	}	
	
	public void addToMenuTools(JMenuItem item) {
		jMenuTools.add(item);
	}
	
	public void addToWestPanel(JPanel panel) {
		jPanelMain.add(panel);
	}
	
	/**
	 * 
	 */
	public void addToColorPanel(JPanel panel) {
        getContentPane().add(panel, java.awt.BorderLayout.CENTER);
	}	

	public void addToHandlePanel(JComponent component){
		JHandlePanel panel = new JHandlePanel();
		panel.setParentFrame(this);
		panel.setMainComponent(component);
		panel.setTitle(component.toString());
	    jPanelAdd.add(panel);	
	}
	
	public void addToOptionPanel(JPanel panel) {
		jContentPaneOption.add(panel);
	}	
	
	public String toString(){
		return "ViewFrameMain";
	}
	
	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" ꂽR[h">//GEN-BEGIN:initComponents
    private void initComponents() {
        optionDialog = new javax.swing.JDialog();
        optionDialog.setTitle("Option");
        optionDialog.setPreferredSize(new java.awt.Dimension(200,350));
        jMenuBar = new javax.swing.JMenuBar();
        jMenuTools = new javax.swing.JMenu();
        jSeparator1 = new javax.swing.JSeparator();
        jMenuItemOption = new javax.swing.JMenuItem();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("CytoQ");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));

        jMenuTools.setText("Tools");
        jMenuTools.add(jMenuItemOption);

        jMenuTools.add(jSeparator1);
        jMenuItemOption.setText("Option");
        jMenuItemOption.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemOptionActionPerformed(evt);
            }
        });

        setJMenuBar(jMenuBar);

			this.setContentPane(getJContentPane());
			optionDialog.setContentPane(getJContentPaneOption());
        pack();
    }
    // </editor-fold>//GEN-END:initComponents

	/**
	 * 
	 */
	void addToolsToMenuBar() {
		jMenuBar.add(jMenuTools);
	}

	private void jMenuItemOptionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemOptionActionPerformed
		optionDialog.setVisible(true);
	}//GEN-LAST:event_jMenuItemOptionActionPerformed
			
	private javax.swing.JMenuBar jMenuBar;
    private javax.swing.JMenuItem jMenuItemOption;
    private javax.swing.JMenu jMenuTools;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JDialog optionDialog;

	private JPanel jPanelMain = null;

	private JPanel jContentPane = null;

	private JPanel jPanelAdd = null;

	private JLabel jLabelStatus = null;

	private JPanel jContentPaneOption = null;

	/**
	 * This method initializes jPanelMain	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelMain() {
		if (jPanelMain==null) {
			jPanelMain = new JPanel();
			jPanelMain.setLayout(new BoxLayout(getJPanelMain(), BoxLayout.Y_AXIS));
		}
		return jPanelMain;
	}

	/**
	 * This method initializes jContentPane	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJContentPane() {
		if (jContentPane==null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getJPanelMain(), java.awt.BorderLayout.WEST);
			jContentPane.add(getJPanelAdd(), java.awt.BorderLayout.SOUTH);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jPanelAdd	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelAdd() {
		if (jPanelAdd==null) {
			jPanelAdd = new JPanel();
			jPanelAdd.setLayout(new BoxLayout(getJPanelAdd(), BoxLayout.Y_AXIS));
			jPanelAdd.add(getJLabelStatus(), null);
		}
		return jPanelAdd;
	}

	/**
	 * This method initializes jLabelStatus	
	 * 	
	 * @return javax.swing.JLabel	
	 */
	private JLabel getJLabelStatus() {
		if (jLabelStatus==null) {
			jLabelStatus = new JLabel();
			jLabelStatus.setText("Wellcome to CytoQ !");
		}
		return jLabelStatus;
	}

	synchronized public static ViewFrameMain getInstance() {
		if (instance==null){
			instance = new ViewFrameMain();
		}
		return instance;
	}

	/**
	 * This method initializes jContentPane1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJContentPaneOption() {
		if (jContentPaneOption==null) {
			jContentPaneOption = new JPanel();
			jContentPaneOption.setLayout(new BoxLayout(getJContentPaneOption(), BoxLayout.Y_AXIS));
		}
		return jContentPaneOption;
	}

	public void setAbstraction(IPACAbstraction abstraction) {
		setVisible(true);
	}

	void packOptionDialog() {
		optionDialog.pack();
	}

}
