package jp.sourceforge.sos.cytoq.main;

import java.util.ArrayList;
import java.util.Vector;

import javax.swing.DefaultListModel;

public class VariableList extends AbstractVariable{
	private ArrayList<VariableSingle> items = new ArrayList<VariableSingle>();
	
	public VariableList(String string) {
		super(string);
	}
	
	public VariableSingle getItem(int index){
		return items.get(index);
	}

	public void toHeader(DefaultListModel header) {
		for (int i=0; i<items.size(); i++){
			header.addElement(items.get(i));
		}
	}

	public void toResult(Vector<String> data) {
		for (int i=0; i<items.size(); i++){
			items.get(i).toResult(data);
		}
	}
	
	public void remove(){
		items.remove(items.size()-1);
	}
	
	public void add(){
		int index = items.size()+1;
		items.add(new VariableSingle(toString()+index));
	}

	@Override
	public void setValue(String arg) {
		String[] values = arg.split(" ");
		if (values.length!=items.size()){
			System.out.println("error!!");
			
		}
		
		for (int i=0; i<values.length; i++){
			items.get(i).setValue(values[i]);
		}
	}
}
