/*
 * FindingsManager.java
 *
 * Created on 2005/06/12, 19:05
 *
 */

package jp.sourceforge.sos.cytoq.main;

import java.util.HashMap;
import java.util.Vector;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

import sos.designPattern.command.ICommand;
import sos.io.SOSFileIO;
import sos.pac.IPACAbstraction;
import sos.window.DoubleListModel;
import sos.window.ListComboBoxModel;

/**
 * @author Gaku Tanaka
 */
public class ModelMain implements IPACAbstraction, ICommand {

	private DefaultTableModel							modelResultTable	= new DefaultTableModel();

	/**
	 * @uml.property name="modelSelection"
	 * @uml.associationEnd multiplicity="(0 -1)"
	 *                     elementType="jp.sourceforge.sos.cytoq.main.AbstractVariable"
	 */
	private DoubleListModel<AbstractVariable>			modelSelection;

	private ListComboBoxModel							modelHeader			= new ListComboBoxModel();

	private AbstractVariable							itemFileName;

	private static HashMap<String, AbstractVariable>	mapVariable			= new HashMap<String, AbstractVariable>();

	private DefaultListModel							modelPreset			= new DefaultListModel();

	private SOSFileIO									fileIO				= new SOSFileIO();

	public ModelMain() {
		addToMap(new VariableSingle("File"));
		add(new VariableSingle("Time"));
		add(new VariableSingle("Iteration"));
		add(new VariableList("Area"));

		modelSelection = new DoubleListModel<AbstractVariable>(modelPreset, null);
		itemFileName = ModelMain.getItem("File");
		for (int i = 0; i<3; i++) {
			modelSelection.selectFromPreset(i);
		}
		updateHeader();
	}

	public String toString() {
		return "ModelMain";
	}

	/**
	 * @param item
	 */
	private void addToMap(AbstractVariable item) {
		mapVariable.put(item.toString(), item);
	}

	/**
	 * @param arg
	 * @return
	 */
	private void add(AbstractVariable item) {
		addToMap(item);
		modelPreset.addElement(item);
	}

	/**
	 * 
	 */
	private void setHeader() {
		modelHeader.clear();
		itemFileName.toHeader(modelHeader);
		for (int i = 0; i<modelSelection.getSizeSelection(); i++) {
			modelSelection.getSelectionItem(i).toHeader(modelHeader);
		}
	}

	public ComboBoxModel getModelHeader() {
		setHeader();
		return modelHeader;
	}

	public void updateHeader() {
		setHeader();
		modelResultTable.setColumnIdentifiers(modelHeader.toArray());
	}

	DoubleListModel getModel() {
		return modelSelection;
	}

	public AbstractVariable getItem(int i) {
		return modelSelection.getPresetItem(i);
	}

	TableModel getTableModel() {
		return modelResultTable;
	}

	public static AbstractVariable getItem(String arg) {
		return mapVariable.get(arg);
	}

	public VariableSingle getHeader(String name) {
		int index = modelResultTable.findColumn(name);
		return (VariableSingle)modelHeader.get(index);
	}

	public void execute() {
		Vector<String> result = new Vector<String>();

		// default item
		itemFileName.toResult(result);

		// additional items
		for (int i = 0; i<modelSelection.getSizeSelection(); i++) {
			modelSelection.getSelectionItem(i).toResult(result);
		}
		modelResultTable.addRow(result);
	}

	void clear() {
		modelResultTable.setRowCount(0);
	}

	void save() {
		String[] result = new String[modelResultTable.getRowCount()];
		for (int i = 0; i<result.length; i++) {
			StringBuilder builder = new StringBuilder();
			for (int j = 0; j<modelResultTable.getColumnCount(); j++) {
				builder.append(modelResultTable.getValueAt(i, j));
				builder.append(",");
			}
			result[i] = builder.toString();
		}
		fileIO.writeStrings(result);
	}
}
