/**
 * 
 */
package jp.sourceforge.sos.cytoq.main;

import java.awt.Component;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

import sos.designPattern.observer.IObserver;
import sos.designPattern.observer.ISubject;
import sos.pac.AbstractPACControl;
import sos.pac.IPACPresentation;

/**
 * @author Gaku Tanaka
 * 
 */
@SuppressWarnings("unchecked")
public abstract class AbstractControl extends AbstractPACControl {

	public enum AddOption {
		ColorPanel{
			public void add(Object presentation) {
				frame.addToColorPanel((JPanel)presentation);
			}
		},
		WestPanel{
			public void add(Object presentation) {
				frame.addToWestPanel((JPanel)presentation);
			}
		},
		HandlePanel {
	        public void add(Object presentation) {
	        	frame.addToHandlePanel((JComponent)presentation);
	        }
		},
		MENU_TOOLS{
			public void add(Object presentation) {
				frame.addToMenuTools(createMenuItem((Component)presentation));
			}
		},
		PANEL_OPTION{
			public void add(Object presentation){
				frame.addToOptionPanel((JPanel)presentation);
			}
		},
		NULL{
			public void add(Object presentation){
				// NULL Object
			}
		}, MENUBAR{
			public void add(Object menu){
				frame.addToMenuBar((JMenu)menu);
			}
		};
		
		public abstract void add(Object presentation);

		private static ViewFrameMain frame = ViewFrameMain.getInstance();	
	};

	public AbstractControl(AbstractPACControl parent) {
		super(parent);
	}
	
	/**
	 * @param presentation
	 */
	protected void addToViewList(Object presentation, AddOption option) {
		String name = presentation.getClass().getName();
		presentations.put(name,presentation);
		option.add(presentation);	
	}	

	protected void setModel() {
		super.setModel();
		addModelComposition();
	}

	/**
	 * 
	 */
	private void addModelComposition() {
		if (model instanceof IModel) {
			((IPACPresentation)model).setAbstraction(getParentModel());
		}
	}
	
	protected <T>void addModelObserver(){
		ISubject parentModel = (ISubject<T>)getParentModel();
		parentModel.addObserver((IObserver<T>)model);
	}

	protected void linkViewToModel(Object presentation, AddOption option) {
		addToViewList(presentation, option);
		((IPACPresentation)presentation).setAbstraction(model);
	}

	protected void init(){}

	/**
	 * @return
	 */
	protected JFrame getMainFrame() {
		JFrame view = ViewFrameMain.getInstance();
		return view;
	};
	
	/**
	 * @param component
	 * @return
	 */
	protected static JMenuItem createMenuItem(final Component component) {
		JMenuItem item = new JMenuItem();
		item.setText(component.toString());
		item.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                component.setVisible(true);
            }
        });
		return item;
	}
	

}
