package jp.sourceforge.sos.cytoq.equation;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;

import sos.designPattern.observer.IObserver;
import sos.designPattern.observer.ISubject;
import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;


@SuppressWarnings("serial")
public class ViewPanelEquation extends JPanel implements IObserver<String>,IPACPresentation{
	
	private JLabel jLabelEquation = null;
	private JLabel jLabel = null;
	private JLabel jLabelValue = null;

	/**
	 * This is the default constructor
	 */
	public ViewPanelEquation() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.gridx = 1;
		gridBagConstraints2.gridy = 1;
		jLabelValue = new JLabel();
		jLabelValue.setText(" ");
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 1;
		jLabel = new JLabel();
		jLabel.setText("=");
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.gridy = 0;
		jLabelEquation = new JLabel();
		jLabelEquation.setText("JLabel");
		jLabelEquation.setForeground(java.awt.Color.gray);
		this.setLayout(new GridBagLayout());
		this.setSize(300, 200);
		this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Result", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
		this.add(jLabelEquation, gridBagConstraints);
		this.add(jLabel, gridBagConstraints1);
		this.add(jLabelValue, gridBagConstraints2);
	}

	public void update(String obj) {
		if (obj.startsWith("=")){
			jLabelEquation.setText(obj);			
		}else{
			jLabelValue.setText(obj);				
		}
	}

	public void setAbstraction(IPACAbstraction abstraction) {
		ISubject<String> subject = (ISubject<String>)abstraction;
		subject.addObserver(this);
	}

}
