/*
 * JDialogAlgebla.java
 *
 * Created on 2005/04/24, 13:18
 */

package jp.sourceforge.sos.cytoq.equation;

import jp.sourceforge.sos.cytoq.main.VariableSingle;
import jp.sourceforge.sos.cytoq.main.ViewFrameMain;
import sos.designPattern.observer.IObserver;
import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;

/**
 * @author Gaku Tanaka
 */
@SuppressWarnings("serial")
class ViewFrameEquation extends javax.swing.JDialog implements IObserver<String>,IPACPresentation {

	private ModelEquation	model;

	private String			backupEquation;

	private String			backupUnit;

	private Integer			backupDecimal;

	/** Creates new form JDialogAlgebla */
	protected ViewFrameEquation() {
		super(ViewFrameMain.getInstance(), true);
		initComponents();
		jSpinnerDecimal.setValue(DEFAULT_DECIMAL);
	}
	
	public String toString() {
		return "Equation Manager";
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc=" Generated Code
	// ">//GEN-BEGIN:initComponents
	private void initComponents() {
		java.awt.GridBagConstraints gridBagConstraints;

		jButtonAlgeblaOK = new javax.swing.JButton();
		jButtonAlgeblaCancel = new javax.swing.JButton();
		jPanelEditor = new javax.swing.JPanel();
		jComboVariable = new javax.swing.JComboBox();
		jButtonVariable = new javax.swing.JButton();
		jLabel4 = new javax.swing.JLabel();
		jLabel5 = new javax.swing.JLabel();
		jPanelOperator = new javax.swing.JPanel();
		jButtonPlus = new javax.swing.JButton();
		jButtonMinus = new javax.swing.JButton();
		jButtonMultiple = new javax.swing.JButton();
		jButtonDivide = new javax.swing.JButton();
		jButtonLeftParenthesis = new javax.swing.JButton();
		jButtonRightParenthesis = new javax.swing.JButton();
		jLabel6 = new javax.swing.JLabel();
		jButtonConstant = new javax.swing.JButton();
		jLabel1 = new javax.swing.JLabel();
		jLabelEquation = new javax.swing.JLabel();
		jTextConstant = new javax.swing.JTextField();
		jPanel1 = new javax.swing.JPanel();
		jButtonBackspace = new javax.swing.JButton();
		jButtonClear = new javax.swing.JButton();
		jPanelDisplay = new javax.swing.JPanel();
		jLabel2 = new javax.swing.JLabel();
		jTextUnit = new javax.swing.JTextField();
		jLabel3 = new javax.swing.JLabel();
		jSpinnerDecimal = new javax.swing.JSpinner();

		getContentPane().setLayout(new java.awt.GridBagLayout());

		setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		setTitle("Equation Manager");
		addComponentListener(new java.awt.event.ComponentAdapter() {
			public void componentShown(java.awt.event.ComponentEvent evt) {
				formComponentShown(evt);
			}
		});

		jButtonAlgeblaOK.setText("OK");
		jButtonAlgeblaOK.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonAlgeblaOKActionPerformed(evt);
			}
		});

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
		getContentPane().add(jButtonAlgeblaOK, gridBagConstraints);

		jButtonAlgeblaCancel.setText("CANCEL");
		jButtonAlgeblaCancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonAlgeblaCancelActionPerformed(evt);
			}
		});

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		getContentPane().add(jButtonAlgeblaCancel, gridBagConstraints);

		jPanelEditor.setLayout(new java.awt.GridBagLayout());

		jPanelEditor.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Editor", javax.swing.border.TitledBorder.LEADING, javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
		jComboVariable.setPreferredSize(new java.awt.Dimension(150, 24));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 5;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanelEditor.add(jComboVariable, gridBagConstraints);

		jButtonVariable.setText("ADD");
		jButtonVariable.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonVariableActionPerformed(evt);
			}
		});

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 5;
		jPanelEditor.add(jButtonVariable, gridBagConstraints);

		jLabel4.setForeground(java.awt.Color.gray);
		jLabel4.setText("variable: ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 5;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		jPanelEditor.add(jLabel4, gridBagConstraints);

		jLabel5.setForeground(java.awt.Color.gray);
		jLabel5.setText("operator: ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.gridwidth = 3;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanelEditor.add(jLabel5, gridBagConstraints);

		jButtonPlus.setText("+");
		jButtonPlus.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonPlusActionPerformed(evt);
			}
		});

		jPanelOperator.add(jButtonPlus);

		jButtonMinus.setText("-");
		jButtonMinus.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonMinusActionPerformed(evt);
			}
		});

		jPanelOperator.add(jButtonMinus);

		jButtonMultiple.setText("*");
		jButtonMultiple.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonMultipleActionPerformed(evt);
			}
		});

		jPanelOperator.add(jButtonMultiple);

		jButtonDivide.setText("/");
		jButtonDivide.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonDivideActionPerformed(evt);
			}
		});

		jPanelOperator.add(jButtonDivide);

		jButtonLeftParenthesis.setText("(");
		jButtonLeftParenthesis.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonLeftParenthesisActionPerformed(evt);
			}
		});

		jPanelOperator.add(jButtonLeftParenthesis);

		jButtonRightParenthesis.setText(")");
		jButtonRightParenthesis.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonRightParenthesisActionPerformed(evt);
			}
		});

		jPanelOperator.add(jButtonRightParenthesis);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.gridwidth = 3;
		jPanelEditor.add(jPanelOperator, gridBagConstraints);

		jLabel6.setForeground(java.awt.Color.gray);
		jLabel6.setText("constant: ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 4;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		jPanelEditor.add(jLabel6, gridBagConstraints);

		jButtonConstant.setText("ADD");
		jButtonConstant.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonConstantActionPerformed(evt);
			}
		});

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 4;
		jPanelEditor.add(jButtonConstant, gridBagConstraints);

		jLabel1.setForeground(java.awt.Color.gray);
		jLabel1.setText("equation:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridwidth = 3;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanelEditor.add(jLabel1, gridBagConstraints);

		jLabelEquation.setText(" ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridwidth = 3;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		jPanelEditor.add(jLabelEquation, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 4;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		jPanelEditor.add(jTextConstant, gridBagConstraints);

		jButtonBackspace.setText("BACK SPACE");
		jButtonBackspace.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonBackspaceActionPerformed(evt);
			}
		});

		jPanel1.add(jButtonBackspace);

		jButtonClear.setText("CLEAR");
		jButtonClear.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonClearActionPerformed(evt);
			}
		});

		jPanel1.add(jButtonClear);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 6;
		gridBagConstraints.gridwidth = 3;
		jPanelEditor.add(jPanel1, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
		getContentPane().add(jPanelEditor, gridBagConstraints);

		jPanelDisplay.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Display", javax.swing.border.TitledBorder.LEADING, javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
		jLabel2.setForeground(java.awt.Color.gray);
		jLabel2.setText("unit: ");
		jPanelDisplay.add(jLabel2);

		jTextUnit.setText("%");
		jTextUnit.setMinimumSize(new java.awt.Dimension(50, 22));
		jTextUnit.setPreferredSize(new java.awt.Dimension(50, 22));
		jPanelDisplay.add(jTextUnit);

		jLabel3.setForeground(java.awt.Color.gray);
		jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		jLabel3.setText("decimal place: ");
		jLabel3.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
		jPanelDisplay.add(jLabel3);

		jSpinnerDecimal.setPreferredSize(new java.awt.Dimension(50, 20));
		jPanelDisplay.add(jSpinnerDecimal);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridheight = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
		getContentPane().add(jPanelDisplay, gridBagConstraints);

		pack();
	}

	// </editor-fold>//GEN-END:initComponents

	private void jButtonClearActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonClearActionPerformed
		model.clear();
	}// GEN-LAST:event_jButtonClearActionPerformed

	private void jButtonBackspaceActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonBackspaceActionPerformed
		model.remove();
	}// GEN-LAST:event_jButtonBackspaceActionPerformed

	private void jButtonVariableActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonVariableActionPerformed
		model.appendVariable((VariableSingle)jComboVariable.getSelectedItem());
	}// GEN-LAST:event_jButtonVariableActionPerformed

	private void jButtonConstantActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonConstantActionPerformed
		model.appendNonVariable(jTextConstant.getText());
	}// GEN-LAST:event_jButtonConstantActionPerformed

	private void jButtonRightParenthesisActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonRightParenthesisActionPerformed
		model.appendNonVariable(")");
	}// GEN-LAST:event_jButtonRightParenthesisActionPerformed

	private void jButtonLeftParenthesisActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonLeftParenthesisActionPerformed
		model.appendNonVariable("(");
	}// GEN-LAST:event_jButtonLeftParenthesisActionPerformed

	private void jButtonDivideActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonDivideActionPerformed
		model.appendNonVariable("/");
	}// GEN-LAST:event_jButtonDivideActionPerformed

	private void jButtonMultipleActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonMultipleActionPerformed
		model.appendNonVariable("*");
	}// GEN-LAST:event_jButtonMultipleActionPerformed

	private void jButtonMinusActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonMinusActionPerformed
		model.appendNonVariable("-");
	}// GEN-LAST:event_jButtonMinusActionPerformed

	private void jButtonPlusActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonPlusActionPerformed
		model.appendNonVariable("+");
	}// GEN-LAST:event_jButtonPlusActionPerformed

	private void jButtonAlgeblaCancelActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonAlgeblaCancelActionPerformed
		jLabelEquation.setText(backupEquation);
		jTextUnit.setText(backupUnit);
		jSpinnerDecimal.setValue(backupDecimal);
		setVisible(false);
	}// GEN-LAST:event_jButtonAlgeblaCancelActionPerformed

	private void formComponentShown(java.awt.event.ComponentEvent evt) {// GEN-FIRST:event_formComponentShown
		backupEquation = jLabelEquation.getText();
		backupUnit = jTextUnit.getText();
		backupDecimal = (Integer)jSpinnerDecimal.getValue();
		
	}// GEN-LAST:event_formComponentShown

	private void jButtonAlgeblaOKActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonAlgeblaOKActionPerformed
		setVisible(false);
	}// GEN-LAST:event_jButtonAlgeblaOKActionPerformed

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton		jButtonAlgeblaCancel;

	private javax.swing.JButton		jButtonAlgeblaOK;

	private javax.swing.JButton		jButtonBackspace;

	private javax.swing.JButton		jButtonClear;

	private javax.swing.JButton		jButtonConstant;

	private javax.swing.JButton		jButtonDivide;

	private javax.swing.JButton		jButtonLeftParenthesis;

	private javax.swing.JButton		jButtonMinus;

	private javax.swing.JButton		jButtonMultiple;

	private javax.swing.JButton		jButtonPlus;

	private javax.swing.JButton		jButtonRightParenthesis;

	private javax.swing.JButton		jButtonVariable;

	private javax.swing.JComboBox	jComboVariable;

	private javax.swing.JLabel		jLabel1;

	private javax.swing.JLabel		jLabel2;

	private javax.swing.JLabel		jLabel3;

	private javax.swing.JLabel		jLabel4;

	private javax.swing.JLabel		jLabel5;

	private javax.swing.JLabel		jLabel6;

	private javax.swing.JLabel		jLabelEquation;

	private javax.swing.JPanel		jPanel1;

	private javax.swing.JPanel		jPanelDisplay;

	private javax.swing.JPanel		jPanelEditor;

	private javax.swing.JPanel		jPanelOperator;

	private javax.swing.JSpinner	jSpinnerDecimal;

	private javax.swing.JTextField	jTextConstant;

	private javax.swing.JTextField	jTextUnit;

	// End of variables declaration//GEN-END:variables
	static private final Integer	DEFAULT_DECIMAL	= new Integer(2);

	public void update(String obj) {
		if (obj.startsWith("=")){
			jLabelEquation.setText(obj);
		}
	}

	public void setAbstraction(IPACAbstraction abstraction) {
		model = (ModelEquation)abstraction;
		model.addObserver(this);
		jComboVariable.setModel(model.getHeader());
	}

}
