package jp.sourceforge.sos.cytoq.equation;

import java.text.DecimalFormat;
import java.util.ArrayList;

import javax.swing.ComboBoxModel;

import jp.sourceforge.sos.cytoq.main.IModel;
import jp.sourceforge.sos.cytoq.main.ModelMain;
import jp.sourceforge.sos.cytoq.main.VariableSingle;

import sos.designPattern.command.ICommand;
import sos.designPattern.observer.ConcreteSubject;
import sos.designPattern.observer.IObserver;
import sos.designPattern.observer.ISubject;
import sos.math.RevertPolish;
import sos.pac.IPACAbstraction;

/**
 * @uml.dependency supplier="jp.sourceforge.sos.cytoq.analysis.resultData.ModelResultData"
 */
@SuppressWarnings("unchecked")
public class ModelEquation implements IModel, ISubject<String>, ICommand {

	private ArrayList<VariableSingle>	equationItems	= new ArrayList<VariableSingle>();

	private ConcreteSubject<String>		subject		= new ConcreteSubject<String>();

	private ModelMain					modelMain;

	private DecimalFormat				answerFormat	= new DecimalFormat();

	private int							decimal = 2;

	private String						unit = "%";

	/**
	 */
	public ModelEquation() {}

	public void setAbstraction(IPACAbstraction abstraction) {
		modelMain = (ModelMain)abstraction;
		
	}

	/**
	 * 
	 */
	void init() {
		add("100");
		add("*");
		equationItems.add(getVaribale("Area3"));
		add("/");
		add("(");
		equationItems.add(getVaribale("Area2"));
		add("+");
		equationItems.add(getVaribale("Area3"));
		add(")");
		setEquation();
	}

	private VariableSingle getVaribale(String name) {
		return (VariableSingle)modelMain.getHeader(name);
	}

	private void setEquation() {
		StringBuffer buffer = new StringBuffer("=");
		if (equationItems.size()>0) {
			for (int i = 0; i<equationItems.size(); i++) {
				buffer.append(equationItems.get(i));
			}
		}
		subject.inform(buffer.toString());
	}

	void remove() {
		int index = equationItems.size()-1;
		if (0<=index) {
			equationItems.remove(index);
			setEquation();
		}
	}

	void clear() {
		equationItems.clear();
		setEquation();
	}

	void appendVariable(VariableSingle item) {
		equationItems.add(item);
		setEquation();
	}

	void appendNonVariable(String arg) {
		add(arg);
		setEquation();
	}

	/**
	 * @param arg
	 */
	private void add(String arg) {
		equationItems.add(new NonVariable(arg));
	}

	ComboBoxModel getHeader() {
		return modelMain.getModelHeader();
	}

	private String getFormattedValue(double value) {
		answerFormat.setMaximumFractionDigits(decimal);
		return answerFormat.format(value)+unit;
	}

	public void addObserver(IObserver<String> observer) {
		subject.addObserver(observer);
	}

	public void execute() {
		StringBuffer equation = new StringBuffer();
		for (int i = 0; i<equationItems.size(); i++) {
			equation.append(equationItems.get(i).getValue());
		}
		
		String eq = RevertPolish.convert(equation.toString());
		String result = getFormattedValue(RevertPolish.calc(eq));
		subject.inform(result);
	}

}
