package jp.sourceforge.sos.cytoq.color;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Insets;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SwingConstants;
import sos.color.JColorPanel;
import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;

@SuppressWarnings("serial")
class ViewPanelColor extends JPanel implements IPACPresentation{

	private ModelColor	model;
	
	private JPanel jPanel = null;
	private JLabel jLabel = null;
	private JSpinner jSpinner = null;
	private JPanel jPanel1 = null;
	private JPanel jPanel2 = null;
	private JColorPanel jColorPanelInit = null;
	private JPanel jPanel3 = null;
	private JLabel jLabel1 = null;
	private JComboBox jComboPickup = null;
	private JPanel jPanel4 = null;
	private JColorPanel jColorPanelFinal = null;
	private JButton jButton = null;

	private JPanel jPanel5 = null;

	private JLabel jLabel2 = null;

	private JComboBox jComboSort = null;

	private JLabel jLabel3 = null;

	private JComboBox jComboColorSpace = null;

	/**
	 * This method initializes 
	 * 
	 */
	public ViewPanelColor() {
		super();
		initialize();
	}	

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new java.awt.Dimension(536,279));
        this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Colors", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
        this.add(getJPanel(), java.awt.BorderLayout.NORTH);
        this.add(getJPanel1(), java.awt.BorderLayout.CENTER);
			
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel==null) {
			jLabel3 = new JLabel();
			jLabel3.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabel3.setText("color space: ");
			jLabel3.setForeground(java.awt.Color.gray);
			jLabel3.setHorizontalTextPosition(SwingConstants.TRAILING);
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(2);
			gridLayout.setColumns(2);
			jPanel = new JPanel();
			jPanel.setLayout(gridLayout);
			jPanel.add(getJLabel(), null);
			jPanel.add(getJSpinner(), null);
			jPanel.add(jLabel3, null);
			jPanel.add(getJComboBox2(), null);
		}
		return jPanel;
	}

	/**
	 * This method initializes jLabel	
	 * 	
	 * @return javax.swing.JLabel	
	 */
	private JLabel getJLabel() {
		if (jLabel==null) {
			jLabel = new JLabel();
			jLabel.setText("number: ");
			jLabel.setForeground(java.awt.Color.gray);
			jLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		}
		return jLabel;
	}

	/**
	 * This method initializes jSpinner	
	 * 	
	 * @return javax.swing.JSpinner	
	 */
	private JSpinner getJSpinner() {
		if (jSpinner==null) {
			jSpinner = new JSpinner();
		}
		return jSpinner;
	}
	
	/**
	 * This method initializes jPanel1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel1() {
		if (jPanel1==null) {
			jPanel1 = new JPanel();
			jPanel1.setLayout(new BoxLayout(getJPanel1(), BoxLayout.X_AXIS));
			jPanel1.add(getJPanel2(), null);
			jPanel1.add(getJButton(), null);
			jPanel1.add(getJPanel4(), null);
		}
		return jPanel1;
	}

	/**
	 * This method initializes jPanel2	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel2() {
		if (jPanel2==null) {
			jPanel2 = new JPanel();
			jPanel2.setLayout(new BorderLayout());
			jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Initial", javax.swing.border.TitledBorder.LEADING, javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
			jPanel2.add(getJColorPanelInit(), java.awt.BorderLayout.NORTH);
			jPanel2.add(getJPanel3(), java.awt.BorderLayout.SOUTH);
		}
		return jPanel2;
	}

	/**
	 * This method initializes jColorPanel	
	 * 	
	 * @return sos.color.JColorPanel	
	 */
	private JColorPanel getJColorPanelInit() {
		if (jColorPanelInit==null) {
			jColorPanelInit = new JColorPanel();
		}
		return jColorPanelInit;
	}

	/**
	 * This method initializes jPanel3	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel3() {
		if (jPanel3==null) {
			jLabel1 = new JLabel();
			jLabel1.setText("source: ");
			jLabel1.setForeground(java.awt.Color.gray);
			jPanel3 = new JPanel();
			jPanel3.setLayout(new BorderLayout());
			jPanel3.add(jLabel1, java.awt.BorderLayout.WEST);
			jPanel3.add(getJComboBox(), java.awt.BorderLayout.CENTER);
		}
		return jPanel3;
	}

	/**
	 * This method initializes jComboColorSpace	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBox() {
		if (jComboPickup==null) {
			jComboPickup = new JComboBox();
		}
		return jComboPickup;
	}

	/**
	 * This method initializes jPanel4	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel4() {
		if (jPanel4==null) {
			jPanel4 = new JPanel();
			jPanel4.setLayout(new BorderLayout());
			jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Final", javax.swing.border.TitledBorder.LEADING, javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
			jPanel4.add(getJColorPanelFinal(), java.awt.BorderLayout.NORTH);
			jPanel4.add(getJPanel6(), java.awt.BorderLayout.SOUTH);
		}
		return jPanel4;
	}

	/**
	 * This method initializes jColorPanel1	
	 * 	
	 * @return sos.color.JColorPanel	
	 */
	private JColorPanel getJColorPanelFinal() {
		if (jColorPanelFinal==null) {
			jColorPanelFinal = new JColorPanel();
		}
		return jColorPanelFinal;
	}

	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton() {
		if (jButton==null) {
			jButton = new JButton();
			jButton.setText("<<");
			jButton.setMargin(new Insets(1,1,1,1));
			jButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					model.setInitColorFromFinal();
				}
			});
		}
		return jButton;
	}

	/**
	 * This method initializes jPanel6	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel6() {
		if (jPanel5==null) {
			jLabel2 = new JLabel();
			jLabel2.setText("sort: ");
			jLabel2.setForeground(java.awt.Color.gray);
			jPanel5 = new JPanel();
			jPanel5.setLayout(new BorderLayout());
			jPanel5.add(jLabel2, java.awt.BorderLayout.WEST);
			jPanel5.add(getJComboBox1(), java.awt.BorderLayout.CENTER);
		}
		return jPanel5;
	}

	/**
	 * This method initializes jComboBox1	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBox1() {
		if (jComboSort==null) {
			jComboSort = new JComboBox();
		}
		return jComboSort;
	}

	public void setAbstraction(IPACAbstraction abstraction) {
		this.model = (ModelColor)abstraction;
		
		jColorPanelInit.setModel(model.getModelInit());
		jColorPanelInit.init(true, "#");
				
		jColorPanelFinal.setModel(model.getModelFinal());
		jColorPanelFinal.init(false, "#");
		
		jComboSort.setModel(model.getFinalEnd());
		jComboPickup.setModel(model.getPickups());
		jComboColorSpace.setModel(model.getColorSpaceModel());
		
		jSpinner.setModel(model.getSpinnerNumberModel());
	}

	/**
	 * This method initializes jComboColorSpace	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBox2() {
		if (jComboColorSpace==null) {
			jComboColorSpace = new JComboBox();
		}
		return jComboColorSpace;
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
