/**
 * 
 */
package jp.sourceforge.sos.cytoq.color;

import sos.color.ColorPanelModel;
import sos.colorspace.IntLuminance;
import sos.util.SortInteger;

/**
 * @author Gaku Tanaka
 *
 */
public class SortLuminance implements ISort {

	static private IntLuminance intLuminance = new IntLuminance();
	
	public String toString(){
		return "Luminance";
	}	

	public int[] sort(ColorPanelModel initModel, ColorPanelModel finalModel) {
		int[][] unit = finalModel.getColorArray();
		int[] luminance = new int[initModel.getColorNumber()];
		for (int un=0; un<initModel.getColorNumber(); un++){
			luminance[un] = intLuminance.fromRGB(unit[un]);
		}
		SortInteger si = new SortInteger(luminance);
		int[][] newUnit = (int[][])si.sort(unit);
		finalModel.updateColor(newUnit);
		initModel.updateColor((int[][])si.sort(initModel.getColorArray()));

		return si.getOrder();
	}

}
