package jp.sourceforge.sos.cytoq.color;

/**
 * @author   Gaku Tanaka
 */
class PresetData {
	static private final String SEPARATOR = "&&";
	/**
	 * @uml.property   name="data"
	 */
	private int[] data;
	/**
	 * @uml.property   name="name"
	 */
	private String name;
	
	PresetData(){
	}
	
	public PresetData(String name, int[] data) {
		this.name = name;
		this.data = data;
	}

	public String toString(){
		return name;
	}
	
	/**
	 * @param name   The name to set.
	 * @uml.property   name="name"
	 */
	protected void setName(String arg){
		name = arg;
	}

	/**
	 * @return   Returns the data.
	 * @uml.property   name="data"
	 */
	protected int[] getData() {
		return data;
	}	
	
	/**
	 * @param data   The data to set.
	 * @uml.property   name="data"
	 */
	protected void setData(int[] datum) {
		data = datum;
	}	

	protected void set(String arg){
		String[] elements = arg.split(SEPARATOR);
		setName(elements[0]);
		
		data = new int[elements.length-1];
		for (int i=1; i<elements.length; i++){
			data[i-1] = Integer.parseInt(elements[i]);
		}
	}
	
	protected String getSaveString(){
		StringBuilder builder = new StringBuilder();
		builder.append(name);
		for (int i=0; i<data.length; i++){
			builder.append(SEPARATOR+data[i]);
		}
		return builder.toString();
	}

}
