package jp.sourceforge.sos.cytoq.color;

import sos.color.ColorModel;
import sos.designPattern.observer.IObserver;
import sos.image.ImageInfo;

/**
 * @author   Gaku Tanaka
 */
public class PickupRandom implements IPickup, IObserver<ColorModel>{
	private ImageInfo imageInfo;
	/**
	 * @uml.property   name="colorNumber"
	 */
	private int colorNumber = 0;
	
	public PickupRandom() {
		// TODO Auto-generated constructor stub
	}

	public String toString(){
		return "Random";
	}	
	
	public int[] getColor() {
		int[] colors = new int[colorNumber];
		for (int un = 0; un<colorNumber; un++) {
			int colorIndex = (int) (Math.random()*imageInfo.getUsedColorNumber());
			colors[un] = imageInfo.getIntRGB(colorIndex);
		}
		return colors;
	}

	public void update(ColorModel arg) {
		if (arg==null){
			colorNumber--;
		}else{
			colorNumber++;
		}
	}

	public void setImageInfo(ImageInfo imageInfo) {
		this.imageInfo = imageInfo;
	}
}