package jp.sourceforge.sos.cytoq.color;

import java.awt.Color;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

import jp.sourceforge.sos.cytoq.main.IModel;
import jp.sourceforge.sos.cytoq.main.ModelMain;
import sos.color.ColorModel;
import sos.color.ColorPanelModel;
import sos.colorspace.SOSColorSpace;
import sos.design.ComboModelStrategy;
import sos.designPattern.observer.IObserver;
import sos.designPattern.observer.ISubject;
import sos.pac.IPACAbstraction;

public class ModelColor implements IModel, ISubject<ColorModel> {

	public ColorPanelModel				initModel;

	/**
	 * @uml.property name="pickups"
	 * @uml.associationEnd multiplicity="(0 -1)"
	 *                     elementType="jp.sourceforge.sos.cytoq.analysis.imageColor.colorSpace.initColor.IPickup"
	 */
	private ComboModelStrategy<IPickup>	pickups;

	public ColorPanelModel				finalModel;

	/**
	 * @uml.property name="finalEnd"
	 * @uml.associationEnd multiplicity="(0 -1)"
	 *                     elementType="jp.sourceforge.sos.cytoq.analysis.imageColor.colorSpace.initColor.ISort"
	 */
	private ComboModelStrategy<ISort>	finalEnd;

	private SOSColorSpace				colorSpace;

	private ModelMain					modelMain;

	private SpinnerNumberModel			spinnerNumberModel	= new SpinnerNumberModel();

	private DefaultComboBoxModel		modelColorSpace;

	private DefaultComboBoxModel		modelAnimationColor;

	private ColorPanelModel				animationColor;

	public ModelColor() {
		initModel = new ColorPanelModel();
		initModel.setName("Initial");

		finalModel = new ColorPanelModel();
		finalModel.setName("Final");

		initModel.addObserver(finalModel);

		setInitStart();
		setFinalEnd();

		spinnerNumberModel.addChangeListener(new javax.swing.event.ChangeListener() {
			public void stateChanged(javax.swing.event.ChangeEvent e) {
				initModel.setColorNumber((Integer)spinnerNumberModel.getValue());
				modelMain.updateHeader();
			}
		});
	}

	private void setFinalEnd() {
		finalEnd = new ComboModelStrategy<ISort>();
		finalEnd.add(new SortNull());
		finalEnd.add(new SortLuminance());
	}

	public void setAbstraction(IPACAbstraction abstraction) {
		modelMain = (ModelMain)abstraction;
	}

	ColorPanelModel getModelInit() {
		return initModel;
	}

	public void setInitColor() {
		int[] color = pickups.getSelected().getColor();
		if (0<color.length){
			spinnerNumberModel.setValue(color.length);
			initModel.updateColor(color);
		}
	}

	public void addToPickups(IPickup pickup, int index) {
		pickups.insertElementAt(pickup, index);
	}

	private void setInitStart() {
		pickups = new ComboModelStrategy<IPickup>();
		PickupNull nullPickup = new PickupNull();
		pickups.add(nullPickup);
	}

	public void addObserver(IObserver<ColorModel> observer) {
		initModel.addObserver(observer);
	}

	public int getColorNumber() {
		return initModel.getColorNumber();
	}

	ColorPanelModel getModelFinal() {
		return finalModel;
	}

	ComboBoxModel getFinalEnd() {
		return finalEnd;
	}

	void setInitColorFromFinal() {
		initModel.updateColor(finalModel.getColor());
	}

	public int[] setFinalColorOrder() {
		return finalEnd.getSelected().sort(initModel, finalModel);
	}

	public Color[] getFinalColor() {
		return finalModel.getColor();
	}

	public double[][] toData() {
		return colorSpace.fromRGB(initModel.getColorArray());
	}

	public double[][] convertToData(int[] intRGB) {
		colorSpace = (SOSColorSpace)modelColorSpace.getSelectedItem();
		animationColor = (ColorPanelModel)modelAnimationColor.getSelectedItem();

		double[][] input = new double[intRGB.length][];
		int[] rgb = new int[3];
		for (int i = 0; i<intRGB.length; i++) {
			int value = intRGB[i];
			rgb[0] = (value>>16)&0xFF;
			rgb[1] = (value>>8)&0xFF;
			rgb[2] = (value>>0)&0xFF;
			input[i] = colorSpace.fromRGB(rgb);
		}
		return input;
	}

	/**
	 * 
	 */
	ComboBoxModel getColorSpaceModel() {
		modelColorSpace = new DefaultComboBoxModel();
		modelColorSpace.addElement(SOSColorSpace.getCIELabSpace());
		modelColorSpace.addElement(SOSColorSpace.getRGBSpace());
		return modelColorSpace;
	}

	ComboBoxModel getPickups() {
		return pickups;
	}

	SpinnerModel getSpinnerNumberModel() {
		return spinnerNumberModel;
	}

	public DefaultComboBoxModel getColorModels() {
		modelAnimationColor = new DefaultComboBoxModel();
		modelAnimationColor.addElement(initModel);
		modelAnimationColor.addElement(finalModel);

		return modelAnimationColor;
	}

	public void setSelected(IPickup pickup) {
		pickups.setSelectedItem(pickup);
	}

	public void update(double[][] means) {
		int[][] newColor = colorSpace.toRGB(means);
		finalModel.updateColor(newColor);
	}

	public int[] getAnimationColor() {
		return animationColor.getColorInt();
	}
}
