package jp.sourceforge.sos.cytoq.analysis.process;

import java.awt.GridLayout;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import sos.designPattern.command.ICommand;
import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;

@SuppressWarnings("serial")
class ViewPanelProcess extends JPanel implements IPACPresentation,ICommand {

	private ModelProcess model;
	
	private JComboBox jComboBox = null;
	private JButton jButton = null;
	/**
	 * This method initializes 
	 * 
	 */
	ViewPanelProcess() {
		super();
		initialize();		
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.setColumns(1);
        gridLayout1.setRows(2);
        this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Process", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
        this.setSize(new java.awt.Dimension(82,78));
        this.setLayout(gridLayout1);
        this.add(getJComboBox());
        this.add(getJButton(), null);
			
	}

	/**
	 * This method initializes jComboBox	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBox() {
		if (jComboBox==null) {
			jComboBox = new JComboBox();
		}
		return jComboBox;
	}

	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton() {
		if (jButton==null) {
			jButton = new JButton();
			jButton.setForeground(new java.awt.Color(102,102,255));
			jButton.setText("START");
			jButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					if (model.isStarted()){
						jButton.setText(model.setThreadSuspended());
					}else{
						pack();
						if (model.start()){
							jButton.setText("SUSPEND");
						}
					}
				}
			});
		}
		return jButton;
	}

	private void pack() {
		SwingUtilities.getWindowAncestor(this).pack();
	}

	public void setAbstraction(IPACAbstraction abstraction) {
		model = (ModelProcess)abstraction;
		model.addCommand(this);
		
		jComboBox.setModel(model.getModelProcess());
		jComboBox.setSelectedIndex(0);
	}

	public void execute() {
		jButton.setText("START");
	}

}  //  @jve:decl-index=0:visual-constraint="27,27"
