package jp.sourceforge.sos.cytoq.analysis.process;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;

import java.awt.GridLayout;

@SuppressWarnings("serial")
class ViewPanelOptionProcess extends JPanel implements IPACPresentation{

	private ModelProcess	model	= null;
	private JLabel jLabel = null;
	private JLabel jLabel1 = null;
	private JLabel jLabel2 = null;
	private JSpinner jSpinnerBatchIteration = null;
	private JSpinner jSpinnerEPS = null;
	private JSpinner jSpinnerMaxIteration = null;

	ViewPanelOptionProcess() {
		super();
		initialize();
	}
	
	private void initSpinner(JSpinner spinner, int value, int min, int max) {
		SpinnerNumberModel model = new SpinnerNumberModel(min, min, max, 1);
		spinner.setModel(model);
		spinner.setValue(value);
	}	

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Process", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, null, java.awt.Color.blue));
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(3);
        gridLayout.setColumns(2);
        jLabel2 = new JLabel();
        jLabel2.setText("max iteration: ");
        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel1 = new JLabel();
        jLabel1.setText("EPS(decimal): ");
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel = new JLabel();
        jLabel.setText("batch iteration: ");
        jLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        this.setLayout(gridLayout);
        this.add(jLabel, null);
        this.add(getJSpinnerBatchIteration(), null);
        this.add(jLabel1, null);
        this.add(getJSpinnerEPS(), null);
        this.add(jLabel2, null);
        this.add(getJSpinnerMaxIteration(), null);
			
	}

	/**
	 * This method initializes jSpinner	
	 * 	
	 * @return javax.swing.JSpinner	
	 */
	private JSpinner getJSpinnerBatchIteration() {
		if (jSpinnerBatchIteration==null) {
			jSpinnerBatchIteration = new JSpinner();
			jSpinnerBatchIteration.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent e) {
					int value = (Integer)jSpinnerBatchIteration.getValue();
					ProcessBatch.iteration = value;
					}
			});
		}
		return jSpinnerBatchIteration;
	}

	/**
	 * This method initializes jSpinner1	
	 * 	
	 * @return javax.swing.JSpinner	
	 */
	private JSpinner getJSpinnerEPS() {
		if (jSpinnerEPS==null) {
			jSpinnerEPS = new JSpinner();
			jSpinnerEPS.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent e) {
					double value = Math.pow(0.1, (Integer)jSpinnerEPS.getValue());
					model.setEPS(value);
				}
			});
		}
		return jSpinnerEPS;
	}

	/**
	 * This method initializes jSpinner2	
	 * 	
	 * @return javax.swing.JSpinner	
	 */
	private JSpinner getJSpinnerMaxIteration() {
		if (jSpinnerMaxIteration==null) {
			jSpinnerMaxIteration = new JSpinner();
			jSpinnerMaxIteration.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent e) {
					model.setMaxIteration((Integer)jSpinnerMaxIteration.getValue());
				}
			});
		}
		return jSpinnerMaxIteration;
	}

	public void setAbstraction(IPACAbstraction abstraction) {
		model = (ModelProcess)abstraction;

		initSpinner(jSpinnerBatchIteration, 1, 1, 1000);
		initSpinner(jSpinnerEPS, 7, 0, 16);
		initSpinner(jSpinnerMaxIteration, 1000, 1, Integer.MAX_VALUE);
	}

}
