/*
 * ProcessSingle.java
 *
 * Created on 2005/06/12, 0:05
 *
 */

package jp.sourceforge.sos.cytoq.analysis.process;

import java.io.File;

import jp.sourceforge.sos.cytoq.analysis.ModelAnalysis;

import sos.io.SOSImageIO;

/**
 * @author   Gaku Tanaka
 */
class ProcessSingle implements IProcess{
	private ModelAnalysis modelAnalysis;
	private SOSImageIO imageIO = new SOSImageIO();
	
	public ProcessSingle(ModelAnalysis mode){
		modelAnalysis = mode;
	}

	public String toString(){
		return "Single";
	}
	
	public boolean init() {
		File file = imageIO.getOpenFile();
		if (file == null) {
			return false;
		}
		modelAnalysis.initFile(file);
		return true;
	}
	
	public boolean isConvoluted() {
		modelAnalysis.showResultImages();
		return true;
	}
}
