/*
 * ProcessBatch.java
 *
 * Created on 2005/06/12, 0:45
 *
 */

package jp.sourceforge.sos.cytoq.analysis.process;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

import jp.sourceforge.sos.cytoq.analysis.ModelAnalysis;

import sos.io.SOSFileIO;
import sos.io.SOSImageIO;
import sos.window.JProgressDialog;

/**
 * @author Gaku Tanaka
 */
class ProcessBatch implements IProcess {

	protected static int	iteration = 1;

	private String			saveDir;

	private Iterator<File>	imageIterator;

	private SOSFileIO		imageIO	= new SOSFileIO();

	private ModelAnalysis	modelAnalysis;

	private ArrayList<File>	list	= new ArrayList<File>();

	public ProcessBatch(ModelAnalysis mode) {
		modelAnalysis = mode;
	}

	public String toString() {
		return "Batch";
	}

	public boolean init() {
		File dir = imageIO.getOpenDirectory();
		if (dir==null) {
			return false;
		}

		saveDir = imageIO.getSaveDirectory().getPath();
		if (saveDir==null) {
			return false;
		}

		imageIterator = getIterator(dir);
		modelAnalysis.initFile(imageIterator.next());
		return true;
	}

	private Iterator<File> getIterator(File dir) {
		File[] fileList = dir.listFiles();
		Arrays.sort(fileList);
		
		list.clear();
		JProgressDialog dialog = new JProgressDialog(null);
		dialog.start("Loading images...",false);
		for (int i = 0; i<fileList.length; i++) {
			Image img = SOSImageIO.readImage(fileList[i]);
			if (img!=null) {
				list.add(fileList[i]);
			}
			dialog.setValue(100*i/fileList.length);
		}
		dialog.stop();
		
		int n = list.size();
		for (int t = 1; t<iteration; t++) {
			for (int i = 0; i<n; i++) {
				File file = list.get(i);
				list.add(file);
			}
		}
		return list.iterator();
	}

	public boolean isConvoluted() {
		doAfterEachFile();
		if (imageIterator.hasNext()) {
			modelAnalysis.initFile(imageIterator.next());
			return false;
		} else {
			return true;
		}
	}

	/**
	 * 
	 */
	private void doAfterEachFile() {
		if (saveDir!=null) {
			modelAnalysis.saveResultImages(saveDir);
		}
	}
}
