/*
 * ModelProcess.java
 *
 * Created on 2005/06/21, 23:39
 *
 */

package jp.sourceforge.sos.cytoq.analysis.process;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

import jp.sourceforge.sos.cytoq.analysis.ModelAnalysis;
import jp.sourceforge.sos.cytoq.main.AbstractVariable;
import jp.sourceforge.sos.cytoq.main.IModel;
import jp.sourceforge.sos.cytoq.main.ModelMain;
import sos.designPattern.command.CommandList;
import sos.designPattern.command.ICommand;
import sos.designPattern.command.IInvoker;
import sos.pac.IPACAbstraction;

/**
 * @author Gaku Tanaka
 */
public class ModelProcess implements Runnable, IModel, IInvoker {
	private IProcess				currentMode;

	private volatile boolean		threadSuspended;

	/**
	 * @uml.property name="iteration"
	 */
	private volatile int			iteration;

	private Thread					blinker;

	private int						interval	= 10;

	/**
	 * @uml.property name="maxIteration"
	 */
	private int						maxIteration;

	private long					startTime;

	private DefaultComboBoxModel	modelProcess;

	private AbstractVariable		itemIteration;

	private AbstractVariable		itemRequiredTime;

	private ModelAnalysis			modelAnalysis;

	private double					eps;

	private CommandList			commandList	= new CommandList();
	
	ICommand main;

	/** Creates a new instance of ThreadSegmentation */
	public ModelProcess() {
		itemIteration = ModelMain.getItem("Iteration");
		itemRequiredTime = ModelMain.getItem("Time");
	}

	public void run() {
		Thread thisThread = Thread.currentThread();
		do {
			while (!modelAnalysis.isConvoluted()&&iteration<=maxIteration) {
				modelAnalysis.doMainProcess();
				iteration++;
				sleep(thisThread);
			}
			updateItems();
			modelAnalysis.updateResultData();
			main.execute();
		} while (!currentMode.isConvoluted());
		stop();
	}

	/**
	 * @param thisThread
	 */
	private void sleep(Thread thisThread) {
		try {
			Thread.sleep(interval);
			synchronized (this) {
				while (threadSuspended&&blinker==thisThread) {
					wait();
				}
			}
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	boolean start() {
		currentMode = (IProcess)modelProcess.getSelectedItem();
		boolean value = currentMode.init();
		if (value) {
			init();
			blinker.start();
		}
		return value;
	}

	/**
	 * 
	 */
	private void init() {
		threadSuspended = false;
		blinker = new Thread(this);

		iteration = 1;
		startTime = System.currentTimeMillis();

		modelAnalysis.setEPS(eps);
	}

	private synchronized void stop() {
		commandList.execute();
		blinker = null;
		notify();
	}

	/**
	 * 
	 */
	private void updateItems() {
		itemIteration.setValue(new Integer(iteration).toString());
		int requiredTime = (int) (System.currentTimeMillis()-startTime)/1000;
		itemRequiredTime.setValue(new Integer(requiredTime).toString());
		
		iteration = 0;
		startTime = System.currentTimeMillis();
	}

	synchronized String setThreadSuspended() {
		threadSuspended = !threadSuspended;

		if (!threadSuspended) {
			notify();
			return "SUSPEND";
		}
		return "RESUME";
	}

	boolean isStarted() {
		return (blinker!=null);
	}

	/**
	 * @param maxIteration
	 *            The maxIteration to set.
	 * @uml.property name="maxIteration"
	 */
	void setMaxIteration(int max) {
		maxIteration = max;
	}

	ComboBoxModel getModelProcess() {
		return modelProcess;
	}

	void setEPS(double value) {
		eps = value;
	}

	public void setAbstraction(IPACAbstraction abstraction) {
		modelAnalysis = (ModelAnalysis)abstraction;

		modelProcess = new DefaultComboBoxModel();
		modelProcess.addElement(new ProcessSingle(modelAnalysis));
		modelProcess.addElement(new ProcessBatch(modelAnalysis));
	}

	public void setBatchIteration(int value) {
	}

	public void addCommand(ICommand command) {
		commandList.add(command);
	}
}
