/**
 * 
 */
package jp.sourceforge.sos.cytoq.analysis.imageColor;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;


/**
 * @author Scientific Open Source Project (Gaku Tanaka)
 *
 */
@SuppressWarnings("serial")
class ViewSegmentation extends AbstractView {

	private Animation animation = new Animation();
	
	/**
	 * @param frameTitle
	 */
	public ViewSegmentation(String frameTitle) {
		super(frameTitle);
	}
	
	public void init(){
		super.init();
		animation.setSize(canvas.getWidth(),canvas.getHeight());
		canvas.setImage(createImage(animation.getProducer()));
		canvas.getImageTransform().setFullSrc();
		canvas.repaint();		
	}

	public void update(Color[] colors) {
		if (isShowing()){
			model.setLabelColors(colors);
			model.updateImage(animation);
			canvas.repaint();
		}
	}

	public void componentResized(ComponentEvent e) {
		updateBounds(e);
	}

	public void componentMoved(ComponentEvent e) {
		updateBounds(e);		
	}

	/**
	 * @param e
	 */
	private void updateBounds(ComponentEvent e) {
		Rectangle bounds = e.getComponent().getBounds();
		setLocation(bounds.x+bounds.width, bounds.y);
	}
}
