/**
 * 
 */
package jp.sourceforge.sos.cytoq.analysis.imageColor;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;

import sos.graphics.PointRect;

/**
 * @author Scientific Open Source Project (Gaku Tanaka)
 *
 */
@SuppressWarnings("serial")
class ViewDistribution extends AbstractView {

	/**
	 * @param arg
	 */
	public ViewDistribution(String arg) {
		super(arg);
	}

	public void update(Color[] colors) {
		if (isShowing()){
			for (int i=0; i<model.getRectNumber(); i++){
				PointRect pr = (PointRect)canvas.getGraphicObject(i);
				int[] p = model.convertRect(i);				
				pr.setLocation(p[0], p[1]);
				pr.setRectColor(colors[i]);
			}
			canvas.repaint();
		}
	}

	public void componentResized(ComponentEvent e) {
		Rectangle bounds = e.getComponent().getBounds();
		setLocation(bounds.x, bounds.y+bounds.height);
	}

	public void componentMoved(ComponentEvent e) {		
	}

	public void init() {
		model.setLabelColors();
		super.init();
		adjustPointRect();
	}

	private void adjustPointRect() {
		int n= model.getRectNumber()-canvas.getGrahicsObjectsNumber();
		if (0<n){
			for (int i=0; i<n; i++){
				addRect();
			}
		}else{
			for (int i=0; i<-n; i++){
				removeRect();
			}
		}
	}

	private void addRect() {
		PointRect pr = new PointRect(0, 0, 10);
		pr.setDrawBounds(true);
		pr.setFillRect(true);
		pr.setBoundsColor(Color.black);
		canvas.addGraphicObject(pr);
	}

	private void removeRect() {
		canvas.removeGraphicObject(canvas.getGrahicsObjectsNumber()-1);
	}

}
