package jp.sourceforge.sos.cytoq.analysis.imageColor;

import javax.swing.JFrame;
import javax.swing.JMenu;

import sos.pac.AbstractPACControl;


public class ControlImageColor extends jp.sourceforge.sos.cytoq.main.AbstractControl {
	
	private AbstractView[] views;

	public ControlImageColor(AbstractPACControl parent) {
		super(parent);
	}

	@Override
	protected void setPresentations() {
		views = new AbstractView[2];
		views[0] = new ViewDistribution("Color Map");
		views[1] = new ViewSegmentation("Label Map");
		
		linkViewToModel(views[0],AddOption.NULL);
		linkViewToModel(views[1],AddOption.NULL);
		
		addToMenuBar();
	}

	/**
	 * 
	 */
	private void addToMenuBar() {
		JMenu menu = new JMenu("Window");
		for (int i=0; i<views.length; i++){
			menu.add(createMenuItem(views[i]));
		}
		AddOption.MENUBAR.add(menu);
	}

	public void init() {
		JFrame viewMain = getMainFrame();
		viewMain.addComponentListener(views[0]);
		views[0].addComponentListener(views[1]);
		
		int w = viewMain.getWidth()/2;		
		for (JFrame frame: views){
			frame.setSize(w,w);
			frame.setVisible(true);
		}
	}
}
