package jp.sourceforge.sos.cytoq.analysis.imageColor;

import java.awt.Dimension;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;

public class Animation {
	private Dimension size = new Dimension();
	private MemoryImageSource mis;
	private int[] pixels;
	private int BACKGROUND_COLOR = 0xff000000;
	
	public Animation() {
		super();
	}

	public void setSize(int width, int height){
		size.setSize(width,height);
		pixels = new int[width*height];
		Arrays.fill(pixels, BACKGROUND_COLOR);		
		mis = new MemoryImageSource(width,height,pixels,0,width);
		mis.setAnimated(true);
	}
	
	public int[] getPixels(){
		return pixels;
	}
	
	public void update(){
		mis.newPixels();
	}

	public ImageProducer getProducer() {
		return mis;
	}
	
	public int getWidth(){
		return size.width;
	}
	
	public int getHeight(){
		return size.height;
	}
}
