package jp.sourceforge.sos.cytoq.analysis.imageColor;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

import javax.swing.JFrame;

import jp.sourceforge.sos.cytoq.analysis.IView;
import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;

/**
 * @author Gaku Tanaka
 */
abstract class AbstractView extends JFrame implements IView, IPACPresentation, ComponentListener {

	private String						titleBase;

	protected sos.canvas.JObjectCanvas	canvas;

	protected ModelImageColor			model;

	/** Creates new form AbstractView */
	public AbstractView(String arg) {
		initComponents();
		titleBase = arg;
		setTitle(arg);
	}

	public String toString() {
		return titleBase;
	}

	/**
	 * @param pointsToImage
	 *            The pointsToImage to set.
	 * @uml.property name="ModelEquation"
	 */
	public void setAbstraction(IPACAbstraction abstraction) {
		model = (ModelImageColor)abstraction;
		model.addViewer(this);
	}

	private void initComponents() {
		canvas = new sos.canvas.JObjectCanvas();
		getContentPane().add(canvas, java.awt.BorderLayout.CENTER);
	}

	public void componentShown(ComponentEvent e) {}

	public void componentHidden(ComponentEvent e) {}
	
	/**
	 * 
	 */
	private void setCanvas() {
		int h = model.getHeight(canvas.getWidth());
		canvas.setSize(canvas.getWidth(), h);
		canvas.setImage(model.getImage(canvas.getWidth(), h));
		canvas.getImageTransform().setFullSrc();

		setTitle(titleBase+" ("+model.getName()+")");
		pack();
	}
	
	public void init(){
		setCanvas();
	}
	
	public void post(){};
}
