/**
 * 
 */
package jp.sourceforge.sos.cytoq.analysis.algorithm;

import java.awt.BorderLayout;

import javax.swing.JComboBox;
import javax.swing.JPanel;

import jp.sourceforge.sos.cytoq.main.SegmentationAlgorithm;
import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;

/**
 * @author Gaku Tanaka
 * 
 */
@SuppressWarnings("serial")
class ViewPanelAlgorithm extends JPanel implements IPACPresentation {

	private JComboBox		jComboBox	= null;

	private JPanel			jPanelOption;

	private ModelAlgorithm	model;

	/**
	 * This method initializes
	 * 
	 */
	public ViewPanelAlgorithm() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		this.setLayout(new BorderLayout());
		this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Algorithm", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
		this.add(getJComboBox(), java.awt.BorderLayout.NORTH);

	}

	/**
	 * This method initializes jComboBox
	 * 
	 * @return javax.swing.JComboBox
	 */
	private JComboBox getJComboBox() {
		if (jComboBox==null) {
			jComboBox = new JComboBox();
			jComboBox.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					setClusteringOption();
				}
			});
		}
		return jComboBox;
	}
	
	public void setAbstraction(IPACAbstraction abstraction) {
		model = (ModelAlgorithm)abstraction;
		jComboBox.setModel(model.getModel());
		setClusteringOption();
	}	

	private void setClusteringOption() {
		SegmentationAlgorithm clustering = (SegmentationAlgorithm)jComboBox.getSelectedItem();
		if (clustering!=null) {
			if (jPanelOption!=null) {
				remove(jPanelOption);
			}
			jPanelOption = clustering.getOptionPanel();
			add(jPanelOption, BorderLayout.CENTER);

//			((Window)SwingUtilities.getWindowAncestor(this)).pack();
			model.update();
		}
	}

}
