/**
 * 
 */
package jp.sourceforge.sos.cytoq.analysis.algorithm;

import java.io.File;

import javax.swing.DefaultComboBoxModel;

import jp.sourceforge.sos.cytoq.analysis.ModelAnalysis;
import jp.sourceforge.sos.cytoq.main.IModel;
import jp.sourceforge.sos.cytoq.main.SegmentationAlgorithm;
import sos.io.Extension;
import sos.io.PluginClassLoader;
import sos.pac.IPACAbstraction;

/**
 * @uml.dependency   supplier="jp.sourceforge.sos.cytoq.analysis.ModelAnalysis"
 */
public class ModelAlgorithm implements IModel{
	
	private ModelAnalysis parent;

	private PluginClassLoader loader;

	private DefaultComboBoxModel plugins = new DefaultComboBoxModel();

	/**
	 * 
	 */
	public ModelAlgorithm() {
		File dir = new File(setPath());
		loader = new PluginClassLoader(dir.getPath());
		File[] fileList = dir.listFiles();
		
		if (fileList != null) {
			for (int i = 0; i < fileList.length; i++) {
				SegmentationAlgorithm algorithm = getAlgorithm(fileList[i].getName());
				if (algorithm!=null){
					plugins.addElement(algorithm);
				}
			}
		}
	}

	/**
	 * @return
	 */
	private String setPath() {
		StringBuffer pathBuffer = new StringBuffer(System.getProperty("user.dir"));
		pathBuffer.append(File.separator);
		pathBuffer.append("plugins");
		pathBuffer.append(File.separator);
		pathBuffer.append("segmentation");

		return pathBuffer.toString();
	}

	/**
	 * @param algorithmName
	 */
	private SegmentationAlgorithm getAlgorithm(String algorithmName) {
		if (algorithmName != null) {
			algorithmName = Extension.remove(algorithmName);
			try {
				return (SegmentationAlgorithm) loader.loadClass(algorithmName).newInstance();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return null;
	}


	DefaultComboBoxModel getModel() {
		return plugins;
	}

	void update() {
		parent.setAlgorithm((SegmentationAlgorithm)plugins.getSelectedItem());
	}

	public void setAbstraction(IPACAbstraction abstraction) {
		parent = (ModelAnalysis)abstraction;
	}	
}
