package jp.sourceforge.sos.cytoq.analysis;

import java.awt.GridLayout;

import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;

import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;

@SuppressWarnings("serial")
class ViewPanelOption extends JPanel implements IPACPresentation{

	private JCheckBox jCheckBox = null;
	private JComboBox	jComboBox;
	private ModelAnalysis	model;
	private JSpinner jSpinner = null;
	private JPanel jPanel = null;
	private JPanel jPanel1 = null;
	private JLabel jLabel3 = null;
	private JLabel jLabel4 = null;
	private JLabel jLabel5 = null;
	private JCheckBox jCheckBox1 = null;
	private JCheckBox jCheckBox2 = null;
	private JCheckBox jCheckBox3 = null;

	ViewPanelOption() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        this.setBorder(javax.swing.BorderFactory.createEmptyBorder(0,0,0,0));
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(2);
        this.setLayout(gridLayout);
        this.add(getJPanel(), null);
        this.add(getJPanel1(), null);
	}

	/**
	 * This method initializes jCheckBox	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJCheckBox() {
		if (jCheckBox==null) {
			jCheckBox = new JCheckBox();
			jCheckBox.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					boolean b = jCheckBox.isSelected();
					jSpinner.setEnabled(b);
					jComboBox.setEnabled(b);
					model.setVisible(b);
				}
			});
		}
		return jCheckBox;
	}

	/**
	 * This method initializes jComboBox	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBox() {
		if (jComboBox==null) {
			jComboBox = new JComboBox();
		}
		return jComboBox;
	}

	public void setAbstraction(IPACAbstraction abstraction) {
		model = (ModelAnalysis)abstraction;
		
		jComboBox.setModel(model.getColorModels());
		jSpinner.setModel(model.getMagnificationModel());
		jCheckBox.setSelected(true);
	}

	/**
	 * This method initializes jSpinner	
	 * 	
	 * @return javax.swing.JSpinner	
	 */
	private JSpinner getJSpinner() {
		if (jSpinner==null) {
			jSpinner = new JSpinner();
		}
		return jSpinner;
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel==null) {
			jLabel5 = new JLabel();
			jLabel5.setText("color: ");
			jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
			jLabel4 = new JLabel();
			jLabel4.setText("magnification: ");
			jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
			jLabel3 = new JLabel();
			jLabel3.setText("show: ");
			jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
			GridLayout gridLayout1 = new GridLayout();
			gridLayout1.setRows(3);
			gridLayout1.setColumns(2);
			jPanel = new JPanel();
			jPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Animation", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
			jPanel.setLayout(gridLayout1);
			jPanel.add(jLabel3, null);
			jPanel.add(getJCheckBox(), null);
			jPanel.add(jLabel4, null);
			jPanel.add(getJSpinner(), null);
			jPanel.add(jLabel5, null);
			jPanel.add(getJComboBox(), null);
		}
		return jPanel;
	}

	/**
	 * This method initializes jPanel1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel1() {
		if (jPanel1==null) {
			GridLayout gridLayout2 = new GridLayout();
			gridLayout2.setRows(3);
			gridLayout2.setColumns(1);
			jPanel1 = new JPanel();
			jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Result images", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
			jPanel1.setLayout(gridLayout2);
			jPanel1.add(getJCheckBox1(), null);
			jPanel1.add(getJCheckBox2(), null);
			jPanel1.add(getJCheckBox3(), null);
		}
		return jPanel1;
	}

	/**
	 * This method initializes jCheckBox1	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJCheckBox1() {
		if (jCheckBox1==null) {
			jCheckBox1 = new JCheckBox();
			jCheckBox1.setText("original");
			jCheckBox1.setSelected(true);
			jCheckBox1.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					AbstractButton button  = (AbstractButton)e.getSource();
					model.resultImages[0].setVisible(button.isSelected());
				}
			});
		}
		return jCheckBox1;
	}

	/**
	 * This method initializes jCheckBox2	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJCheckBox2() {
		if (jCheckBox2==null) {
			jCheckBox2 = new JCheckBox();
			jCheckBox2.setText("initial");
			jCheckBox2.setSelected(true);
			jCheckBox2.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					AbstractButton button  = (AbstractButton)e.getSource();
					model.resultImages[1].setVisible(button.isSelected());				}
			});
		}
		return jCheckBox2;
	}

	/**
	 * This method initializes jCheckBox3	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJCheckBox3() {
		if (jCheckBox3==null) {
			jCheckBox3 = new JCheckBox();
			jCheckBox3.setText("final");
			jCheckBox3.setSelected(true);
			jCheckBox3.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					AbstractButton button  = (AbstractButton)e.getSource();
					model.resultImages[2].setVisible(button.isSelected());				}
			});
		}
		return jCheckBox3;
	}
	
}  //  @jve:decl-index=0:visual-constraint="193,-2"
