package jp.sourceforge.sos.cytoq.analysis;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

import jp.sourceforge.sos.cytoq.analysis.imageColor.Animation;

import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;
import sos.window.JImageStackFrame;

@SuppressWarnings("serial")
class ViewFrame implements IPACPresentation, ComponentListener, IView {

	private JImageStackFrame	viewer		= new JImageStackFrame();

	private ModelAnalysis		model;

	ViewFrame() {
		super();
	}

	public void componentResized(ComponentEvent e) {
		Rectangle bounds = e.getComponent().getBounds();
		viewer.setLocation(bounds.x+bounds.width, bounds.y);
	}

	public void componentMoved(ComponentEvent e) {}

	public void componentShown(ComponentEvent e) {}

	public void componentHidden(ComponentEvent e) {}

	public void setAbstraction(IPACAbstraction abstraction) {
		model = (ModelAnalysis)abstraction;
		model.addViewer(this);
	}

	public void init() {
		if (model.isVisible()) {
			Animation animation = model.getAnimation();
			viewer.setCanvasSize(model.getCanvasWidth(), model.getCanvasHeight());
			viewer.setTitle("Process ("+model.getFileName()+")");
			viewer.setImage(viewer.createImage(animation.getProducer()));
		}
		viewer.setVisible(model.isVisible());

	}

	public void update(Color[] colors) {
		if (viewer.isShowing()) {
			model.updateAnimation();
			viewer.repaint();
		}
	}

	public void post() {
		viewer.clearImage();
		for (int i = 0; i<model.resultImagesNumber(); i++) {
			viewer.addImage(model.getImage(i));
		}
		if (0<viewer.getImageNumber()) {
			viewer.setTitle("Results("+model.getFileName()+")");
			viewer.setVisible(true);
		}
	}

}
