/**
 * 
 */
package jp.sourceforge.sos.cytoq.analysis;

import javax.swing.JFrame;

import jp.sourceforge.sos.cytoq.main.AbstractControl;
import sos.color.ColorModel;
import sos.pac.AbstractPACControl;

/**
 * @author Gaku Tanaka
 *
 */

@SuppressWarnings("unchecked")
public class ControlAnalysis extends AbstractControl {

	private ViewFrame view;
	
	/**
	 * @param parent
	 */
	public ControlAnalysis(AbstractPACControl parent) {
		super(parent);
		super.<ColorModel>addModelObserver();
	}

	/* (non-Javadoc)
	 * @see sos.pac.AbstractPACControl#setPresentations()
	 */
	@Override
	protected void setPresentations() {
		view = new ViewFrame();
		linkViewToModel(view,AddOption.NULL);
		linkViewToModel(new ViewPanelOption(),AddOption.PANEL_OPTION);
	}
	
	public void init() {
		JFrame viewMain = getMainFrame();
		viewMain.addComponentListener(view);
	}	
	
}
