package jp.sourceforge.sos.cytoq.analysis;

import java.awt.Image;
import java.awt.image.BufferedImage;


import sos.color.ColorPanelModel;
import sos.image.ImageInfo;

public class ColorPanelImage extends AbstractViewImage {

	private ColorPanelModel	colorArrayModel;

	public ColorPanelImage(String string, ColorPanelModel model) {
		super(string);
		colorArrayModel = model;
	}

	@Override
	Image createImageFromImageInfo(ImageInfo imageInfo) {
		BufferedImage img = new BufferedImage(imageInfo.getWidth(), imageInfo.getHeight(), BufferedImage.TYPE_INT_RGB);
		img.getGraphics().drawImage(imageInfo.createImage(colorArrayModel.getColorInt()), 0, 0, null);
		return img;
	}

}
