/**
 * 
 */
package jp.sourceforge.sos.cytoq.analysis;

import java.awt.Image;

import sos.image.ImageInfo;



/**
 * @author   Gaku Tanaka
 */
public abstract class AbstractViewImage {

	private boolean visible = true;
	
	/**
	 * @uml.property   name="name"
	 */
	private String	name;
	
	AbstractViewImage(String arg) {
		name = arg;
	}	
	
	/**
	 * @return   Returns the name.
	 * @uml.property   name="name"
	 */
	public String toString(){
		return name;
	}
	
	public void setVisible(boolean value){
		visible = value;
	}
	
	boolean isVisible(){
		return visible;
	}	
	
	Image createImage(ImageInfo imageInfo){
		if (visible){
			return createImageFromImageInfo(imageInfo);
		}
		return null;
	}

	abstract Image createImageFromImageInfo(ImageInfo imageInfo);
	
}
