/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.awt.Graphics;
import java.awt.Point;
import sos.math.MathMatrix;

public class Oval {
    private double[][] basicPoints;
    private double basicRadius = 1.0;
    private double[][] p;
    private double xCenter;
    private double yCenter;

    public Oval(int n) {
        this.setResolution(n);
    }

    public int getResolution() {
        return this.basicPoints.length;
    }

    public final void setResolution(int n) {
        this.basicPoints = new double[n][2];
        this.p = new double[n][2];
        int i = 0;
        while (i < n) {
            double theta = (double)(i * 2) * Math.PI / (double)n;
            this.basicPoints[i][0] = Math.cos(theta);
            this.basicPoints[i][1] = Math.sin(theta);
            ++i;
        }
    }

    public final void setBasicRadius(double r) {
        this.basicRadius = r;
    }

    private void initialize() {
        int i = 0;
        while (i < this.p.length) {
            this.p[i][0] = this.basicPoints[i][0];
            this.p[i][1] = this.basicPoints[i][1];
            ++i;
        }
    }

    private void setCenter(double x, double y) {
        this.xCenter = x;
        this.yCenter = y;
    }

    private void scale(double r) {
        r *= this.basicRadius;
        int i = 0;
        while (i < this.basicPoints.length) {
            double[] dArray = this.p[i];
            dArray[0] = dArray[0] * r;
            double[] dArray2 = this.p[i];
            dArray2[1] = dArray2[1] * r;
            ++i;
        }
    }

    public void deform(double[][] mx) {
        int i = 0;
        while (i < this.p.length) {
            MathMatrix.multiple(this.p[i], mx, this.p[i]);
            ++i;
        }
    }

    public final void makeOval(double x, double y, double[][] mx) {
        this.initialize();
        this.setCenter(x, y);
        this.deform(mx);
    }

    public final void makeOval(double x, double y, double r, double[][] mx) {
        this.initialize();
        this.setCenter(x, y);
        this.deform(mx);
        this.scale(r);
    }

    public final void makeOval(double x, double y, double r) {
        this.initialize();
        this.setCenter(x, y);
        this.scale(r);
    }

    public Point getPoint(int index) {
        int x = (int)Math.round(this.p[index][0] + this.xCenter);
        int y = (int)Math.round(this.p[index][1] + this.yCenter);
        return new Point(x, y);
    }

    public final void draw(Graphics g) {
        int pre = this.p.length - 1;
        int i = 0;
        while (i < this.p.length) {
            Point p1 = this.getPoint(pre);
            Point p2 = this.getPoint(i);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            pre = i++;
        }
    }
}

