/*
 * Decompiled with CFR 0.152.
 */
package sos.process;

import sos.image.ImageInfo;
import sos.math.MathVector;
import sos.process.NeighborFrame;
import sos.util.FirstInFirstOut;
import sos.util.Sort;
import sos.util.SortDouble;
import sos.util.SortInteger;

public class Watershed {
    private static int indexInitial;
    private static int indexUndetermined;
    private static int indexWatershed;
    private static FirstInFirstOut fifoMain;
    private static FirstInFirstOut fifoWshed;
    private NeighborFrame neighborF = null;
    private ImageInfo imi = null;
    private int[] order = null;
    private int[] denomination = null;
    private int waterLevel;

    static {
        fifoMain = new FirstInFirstOut(1);
        fifoWshed = new FirstInFirstOut(1);
    }

    public Watershed(ImageInfo imi, int firstLabel) {
        this.imi = imi;
        if (fifoMain.getCapacity() < imi.getImageSize()) {
            fifoMain = new FirstInFirstOut(imi.getImageSize());
            fifoWshed = new FirstInFirstOut(imi.getImageSize());
        }
        indexInitial = firstLabel - 4;
        indexWatershed = firstLabel - 2;
        indexUndetermined = firstLabel - 1;
        this.waterLevel = 2;
        this.neighborF = imi.getNeighborFrame();
    }

    public final void setOrder(double[] gradient) {
        int pn = 0;
        while (pn < this.imi.getImageSize()) {
            if (this.imi.getPixelsLabel(pn) > indexUndetermined) {
                gradient[pn] = 0.0;
            } else {
                int n = pn;
                gradient[n] = gradient[n] + 1.0;
            }
            ++pn;
        }
        SortDouble sd = new SortDouble(gradient);
        this.setOrderAndDenomination(sd);
    }

    public final void setOrder(int[] gradient) {
        int pn = 0;
        while (pn < this.imi.getImageSize()) {
            if (this.imi.getPixelsLabel(pn) > indexUndetermined) {
                gradient[pn] = 0;
            } else {
                int n = pn;
                gradient[n] = gradient[n] + 1;
            }
            ++pn;
        }
        SortInteger si = new SortInteger(gradient);
        this.setOrderAndDenomination(si);
    }

    private final void setOrderAndDenomination(Sort so) {
        this.order = so.getOrder();
        this.denomination = so.getDistributive();
    }

    public final boolean isConvergence() {
        if (this.waterLevel + 1 < this.denomination.length) {
            ++this.waterLevel;
            return false;
        }
        return true;
    }

    public final int flood4() {
        this.neighborF.set4();
        return this.flood();
    }

    public final int flood8() {
        this.neighborF.set8();
        return this.flood();
    }

    private final int flood() {
        int[] neighbor;
        int count = 0;
        int i = this.denomination[this.waterLevel - 1];
        while (i < this.denomination[this.waterLevel]) {
            this.imi.setPixelsLabel(this.order[i], indexUndetermined);
            neighbor = this.neighborF.getExist(this.order[i]);
            int n = 0;
            while (n < neighbor.length) {
                if (this.imi.getPixelsLabel(this.order[i] + neighbor[n]) > indexUndetermined) {
                    fifoMain.add(this.order[i]);
                    break;
                }
                ++n;
            }
            ++i;
        }
        while (!fifoMain.isEmpty()) {
            int cn;
            int cp = fifoMain.get();
            ++count;
            if (this.imi.getPixelsLabel(cp) != indexUndetermined) continue;
            neighbor = this.neighborF.getExist(cp);
            int n = 0;
            while (n < neighbor.length) {
                cn = cp + neighbor[n];
                if (this.imi.getPixelsLabel(cn) > indexUndetermined) {
                    if (this.imi.getPixelsLabel(cp) == indexUndetermined) {
                        this.imi.setPixelsLabel(cp, this.imi.getPixelsLabel(cn));
                    } else if (this.imi.getPixelsLabel(cp) != this.imi.getPixelsLabel(cn)) {
                        this.imi.setPixelsLabel(cp, indexWatershed);
                        fifoWshed.add(cp);
                        break;
                    }
                }
                ++n;
            }
            if (this.imi.getPixelsLabel(cp) <= indexUndetermined) continue;
            n = 0;
            while (n < neighbor.length) {
                cn = cp + neighbor[n];
                if (this.imi.getPixelsLabel(cn) == indexUndetermined) {
                    fifoMain.add(cn);
                }
                ++n;
            }
        }
        return count;
    }

    public final void undeterminedToWatershed() {
        int pn = 0;
        while (pn < this.neighborF.size) {
            if (this.imi.getPixelsLabel(pn) == indexUndetermined) {
                this.imi.setPixelsLabel(pn, indexWatershed);
                fifoWshed.add(pn);
            }
            ++pn;
        }
    }

    public final void assignLabelOfClosest(int[][] input) {
        this.undeterminedToWatershed();
        do {
            int pn = fifoWshed.get();
            int[] neighbor = this.neighborF.getExist(pn);
            int[] norm = new int[neighbor.length];
            int n = 0;
            while (n < neighbor.length) {
                norm[n] = MathVector.norm(input[pn], input[pn + neighbor[n]]);
                ++n;
            }
            this.setClosestLabel(pn, neighbor, new SortInteger(norm));
        } while (!fifoWshed.isEmpty());
    }

    public final void assignLabelOfClosest(int[][] input, int[] pns) {
        int i = 0;
        while (i < pns.length) {
            int pn = pns[i];
            int[] neighbor = this.neighborF.getExist(pn);
            int[] norm = new int[neighbor.length];
            int n = 0;
            while (n < neighbor.length) {
                norm[n] = MathVector.norm(input[pn], input[pn + neighbor[n]]);
                ++n;
            }
            this.setClosestLabel(pn, neighbor, new SortInteger(norm));
            ++i;
        }
    }

    public final void assignLabelOfClosest(double[][] input) {
        this.undeterminedToWatershed();
        do {
            int pn = fifoWshed.get();
            int[] neighbor = this.neighborF.getExist(pn);
            double[] norm = new double[neighbor.length];
            int n = 0;
            while (n < neighbor.length) {
                norm[n] = MathVector.norm(input[pn], input[pn + neighbor[n]]);
                ++n;
            }
            this.setClosestLabel(pn, neighbor, new SortDouble(norm));
        } while (!fifoWshed.isEmpty());
    }

    private final void setClosestLabel(int pn, int[] neighbor, Sort so) {
        int[] order = so.getOrder();
        int n = 0;
        while (n < neighbor.length) {
            int cn = pn + neighbor[order[n]];
            if (this.imi.getPixelsLabel(cn) > indexUndetermined) {
                this.imi.setPixelsLabel(pn, this.imi.getPixelsLabel(cn));
                return;
            }
            ++n;
        }
    }

    public final int[] getWatershed() {
        return fifoWshed.toArray();
    }

    public final FirstInFirstOut getFIFO() {
        return fifoMain;
    }

    public final void setFIFOMarker() {
        fifoMain.setMarker();
    }

    public int getIndexWatershed() {
        return indexWatershed;
    }

    public int getIndexInitial() {
        return indexInitial;
    }
}

