/*
 * Decompiled with CFR 0.152.
 */
package sos.process;

import java.util.Arrays;
import sos.math.MathVector;
import sos.process.NeighborFrame;
import sos.util.FirstInFirstOut;

public class Morphology {
    private static FirstInFirstOut fifo = null;
    private NeighborFrame neighborFrame = null;

    public Morphology(NeighborFrame neighborF) {
        this.neighborFrame = neighborF;
        fifo = new FirstInFirstOut(neighborF.size);
    }

    public Morphology(int width, int height) {
        this.neighborFrame = new NeighborFrame(width, height);
        fifo = new FirstInFirstOut(this.neighborFrame.size);
    }

    public final int getWidth() {
        return this.neighborFrame.width;
    }

    public final int getHeight() {
        return this.neighborFrame.height;
    }

    public final double[] calcSobel(int[][] color) {
        this.neighborFrame.set8();
        double[] gradient = new double[color.length];
        int[] n = new int[8];
        int[] vec = new int[3];
        int pn = 0;
        while (pn < gradient.length) {
            int v2;
            int v1;
            n = this.neighborFrame.getDir(pn);
            int d = 0;
            while (d < 3) {
                v1 = color[pn + n[0]][d] + 2 * color[pn + n[1]][d] + color[pn + n[2]][d];
                v2 = color[pn + n[4]][d] + 2 * color[pn + n[5]][d] + color[pn + n[6]][d];
                vec[d] = v1 - v2;
                ++d;
            }
            int value = MathVector.dot(vec, vec);
            d = 0;
            while (d < 3) {
                v1 = color[pn + n[2]][d] + 2 * color[pn + n[3]][d] + color[pn + n[4]][d];
                v2 = color[pn + n[6]][d] + 2 * color[pn + n[7]][d] + color[pn + n[0]][d];
                vec[d] = v1 - v2;
                ++d;
            }
            gradient[pn] = Math.sqrt(value += MathVector.dot(vec, vec));
            ++pn;
        }
        return gradient;
    }

    public final double[] calcSobel(double[][] color) {
        this.neighborFrame.set8();
        double[] gradient = new double[color.length];
        int[] n = new int[8];
        double[] vec = new double[3];
        int pn = 0;
        while (pn < gradient.length) {
            double v2;
            double v1;
            n = this.neighborFrame.getDir(pn);
            int d = 0;
            while (d < 3) {
                v1 = color[pn + n[0]][d] + 2.0 * color[pn + n[1]][d] + color[pn + n[2]][d];
                v2 = color[pn + n[4]][d] + 2.0 * color[pn + n[5]][d] + color[pn + n[6]][d];
                vec[d] = v1 - v2;
                ++d;
            }
            double value = MathVector.dot(vec, vec);
            d = 0;
            while (d < 3) {
                v1 = color[pn + n[2]][d] + 2.0 * color[pn + n[3]][d] + color[pn + n[4]][d];
                v2 = color[pn + n[6]][d] + 2.0 * color[pn + n[7]][d] + color[pn + n[0]][d];
                vec[d] = v1 - v2;
                ++d;
            }
            gradient[pn] = Math.sqrt(value += MathVector.dot(vec, vec));
            ++pn;
        }
        return gradient;
    }

    public final double[] calcSobel(double[][] color, int[] table) {
        this.neighborFrame.set8();
        double[] gradient = new double[table.length];
        int[] n = new int[8];
        double[] vec = new double[3];
        int pn = 0;
        while (pn < gradient.length) {
            double v2;
            double v1;
            n = this.neighborFrame.getDir(pn);
            int d = 0;
            while (d < 3) {
                v1 = color[table[pn + n[0]]][d] + 2.0 * color[table[pn + n[1]]][d] + color[table[pn + n[2]]][d];
                v2 = color[table[pn + n[4]]][d] + 2.0 * color[table[pn + n[5]]][d] + color[table[pn + n[6]]][d];
                vec[d] = v1 - v2;
                ++d;
            }
            double value = MathVector.dot(vec, vec);
            d = 0;
            while (d < 3) {
                v1 = color[table[pn + n[2]]][d] + 2.0 * color[table[pn + n[3]]][d] + color[table[pn + n[4]]][d];
                v2 = color[table[pn + n[6]]][d] + 2.0 * color[table[pn + n[7]]][d] + color[table[pn + n[0]]][d];
                vec[d] = v1 - v2;
                ++d;
            }
            gradient[pn] = Math.sqrt(value += MathVector.dot(vec, vec));
            ++pn;
        }
        return gradient;
    }

    public final int[] mean4(int[] data) {
        this.neighborFrame.set4();
        return this.mean(data);
    }

    public final int[] mean8(int[] data) {
        this.neighborFrame.set8();
        return this.mean(data);
    }

    private final int[] mean(int[] data) {
        int[] result = new int[data.length];
        int pn = 0;
        while (pn < data.length) {
            int value = data[pn];
            int[] se = this.neighborFrame.getExist(pn);
            int n = 0;
            while (n < se.length) {
                value += data[pn + se[n]];
                ++n;
            }
            result[pn] = (int)Math.round(1.0 * (double)value / (double)(1 + se.length));
            ++pn;
        }
        return result;
    }

    public final int[] erode4(int[] data) {
        this.neighborFrame.set4();
        return this.erode(data);
    }

    public final int[] erode8(int[] data) {
        this.neighborFrame.set8();
        return this.erode(data);
    }

    private final int[] erode(int[] data) {
        int[] result = new int[data.length];
        int pn = 0;
        while (pn < data.length) {
            int sentinel = data[pn];
            int[] se = this.neighborFrame.getExist(pn);
            int n = 0;
            while (n < se.length) {
                if (sentinel < data[pn + se[n]]) {
                    sentinel = data[pn + se[n]];
                }
                ++n;
            }
            result[pn] = sentinel;
            ++pn;
        }
        return result;
    }

    public final int[] dilate4(int[] data) {
        this.neighborFrame.set4();
        return this.dilate(data);
    }

    public final int[] dilate8(int[] data) {
        this.neighborFrame.set8();
        return this.dilate(data);
    }

    private final int[] dilate(int[] data) {
        int[] result = new int[data.length];
        int pn = 0;
        while (pn < data.length) {
            int sentinel = data[pn];
            int[] se = this.neighborFrame.getExist(pn);
            int n = 0;
            while (n < se.length) {
                if (sentinel > data[pn + se[n]]) {
                    sentinel = data[pn + se[n]];
                }
                ++n;
            }
            result[pn] = sentinel;
            ++pn;
        }
        return result;
    }

    public final int[] open4(int[] data, int t) {
        this.neighborFrame.set4();
        return this.open(data, t);
    }

    public final int[] open8(int[] data, int t) {
        this.neighborFrame.set8();
        return this.open(data, t);
    }

    private final int[] open(int[] data, int t) {
        int[] result = new int[data.length];
        int i = 0;
        while (i < t) {
            result = this.erode(data);
            ++i;
        }
        i = 0;
        while (i < t) {
            result = this.dilate(result);
            ++i;
        }
        return result;
    }

    public final int[] close4(int[] data, int t) {
        this.neighborFrame.set4();
        return this.close(data, t);
    }

    public final int[] close8(int[] data, int t) {
        this.neighborFrame.set8();
        return this.close(data, t);
    }

    private final int[] close(int[] data, int t) {
        int[] result = new int[data.length];
        int i = 0;
        while (i < t) {
            result = this.dilate(data);
            ++i;
        }
        i = 0;
        while (i < t) {
            result = this.erode(result);
            ++i;
        }
        return result;
    }

    public final void reconstruct4(int[] iMask, int[] iMarker) {
        this.neighborFrame.set4();
        this.reconstruct(iMask, iMarker);
    }

    public final void reconstruct8(int[] iMask, int[] iMarker) {
        this.neighborFrame.set8();
        this.reconstruct(iMask, iMarker);
    }

    private final void reconstruct(int[] iMask, int[] iMarker) {
        int cn;
        int n;
        int[] neighbor;
        int max;
        int nHalf = this.neighborFrame.getNumber() / 2;
        int pn = 0;
        while (pn < iMask.length) {
            max = iMarker[pn];
            neighbor = this.neighborFrame.getDir(pn);
            n = nHalf;
            while (n < neighbor.length) {
                cn = pn + neighbor[n];
                if (max < iMarker[cn]) {
                    max = iMarker[cn];
                }
                ++n;
            }
            iMarker[pn] = Math.min(iMask[pn], max);
            ++pn;
        }
        int rpn = iMask.length - 1;
        while (rpn >= 0) {
            max = iMarker[rpn];
            neighbor = this.neighborFrame.getDir(rpn);
            n = 0;
            while (n < nHalf) {
                cn = rpn + neighbor[n];
                if (max < iMarker[cn]) {
                    max = iMarker[cn];
                }
                ++n;
            }
            iMarker[rpn] = Math.min(iMask[rpn], max);
            n = 0;
            while (n < nHalf) {
                cn = rpn + neighbor[n];
                if (iMarker[cn] < iMarker[rpn] && iMarker[cn] < iMask[cn]) {
                    fifo.add(rpn);
                    break;
                }
                ++n;
            }
            --rpn;
        }
        while (!fifo.isEmpty()) {
            int cp = fifo.get();
            neighbor = this.neighborFrame.getDir(cp);
            n = 0;
            while (n < neighbor.length) {
                cn = cp + neighbor[n];
                if (iMarker[cn] < iMarker[cp] && iMarker[cn] != iMask[cn]) {
                    iMarker[cn] = Math.min(iMarker[cp], iMask[cn]);
                    fifo.add(cn);
                }
                ++n;
            }
        }
    }

    public final int[] geodesicDistance4(boolean[] binaryMap) {
        this.neighborFrame.set4();
        return this.geodesicDistance(binaryMap);
    }

    public final int[] geodesicDistance8(boolean[] binaryMap) {
        this.neighborFrame.set8();
        return this.geodesicDistance(binaryMap);
    }

    private final int[] geodesicDistance(boolean[] binaryMap) {
        int[] neighbor;
        int[] distanceMap = new int[binaryMap.length];
        int pn = 0;
        while (pn < binaryMap.length) {
            if (binaryMap[pn]) {
                neighbor = this.neighborFrame.getExist(pn);
                int n = 0;
                while (n < neighbor.length) {
                    if (!binaryMap[pn + neighbor[n]]) {
                        distanceMap[pn] = 1;
                        fifo.add(pn);
                        break;
                    }
                    ++n;
                }
            }
            ++pn;
        }
        while (!fifo.isEmpty()) {
            int cp = fifo.get();
            neighbor = this.neighborFrame.getExist(cp);
            int n = 0;
            while (n < neighbor.length) {
                int cn = cp + neighbor[n];
                if (distanceMap[cn] == 0 && binaryMap[cn]) {
                    distanceMap[cn] = distanceMap[cp] + 1;
                    fifo.add(cn);
                }
                ++n;
            }
        }
        return distanceMap;
    }

    public final int[][] erodeVector4(int[][] data, int[] order) {
        this.neighborFrame.set4();
        return this.erodeVector(data, order);
    }

    public final int[][] erodeVector8(int[][] data, int[] order) {
        this.neighborFrame.set8();
        return this.erodeVector(data, order);
    }

    private final int[][] erodeVector(int[][] data, int[] order) {
        int[][] result = new int[data.length][data[0].length];
        int pn = 0;
        while (pn < data.length) {
            int sentinel = order[pn];
            int winner = pn;
            int[] se = this.neighborFrame.getExist(pn);
            int n = 0;
            while (n < se.length) {
                int cse = pn + se[n];
                if (sentinel < order[cse]) {
                    sentinel = order[cse];
                    winner = cse;
                }
                ++n;
            }
            System.arraycopy(data[winner], 0, result[pn], 0, data[0].length);
            ++pn;
        }
        return result;
    }

    public final int[][] dilateVector4(int[][] data, int[] order) {
        this.neighborFrame.set4();
        return this.dilateVector(data, order);
    }

    public final int[][] dilateVector8(int[][] data, int[] order) {
        this.neighborFrame.set8();
        return this.dilateVector(data, order);
    }

    private final int[][] dilateVector(int[][] data, int[] order) {
        int[][] result = new int[data.length][data[0].length];
        int pn = 0;
        while (pn < data.length) {
            int sentinel = order[pn];
            int winner = pn;
            int[] se = this.neighborFrame.getExist(pn);
            int n = 0;
            while (n < se.length) {
                int cse = pn + se[n];
                if (sentinel > order[cse]) {
                    sentinel = order[cse];
                    winner = cse;
                }
                ++n;
            }
            System.arraycopy(data[winner], 0, result[pn], 0, data[0].length);
            ++pn;
        }
        return result;
    }

    public final int[][] openVector(int[][] data, int[] order) {
        int[][] result = this.erodeVector(data, order);
        result = this.dilateVector(result, order);
        return result;
    }

    public final int[][] closeVector(int[][] data, int[] order) {
        int[][] result = this.dilateVector(data, order);
        result = this.erodeVector(result, order);
        return result;
    }

    public final double texturalFeature(double[][] mx, int index) {
        int ng = mx.length;
        double mu = 0.0;
        int i = 0;
        while (i < ng) {
            int j = 0;
            while (j < ng) {
                mu += (double)i * mx[i][j];
                ++j;
            }
            ++i;
        }
        double[] pxpy = new double[ng * 2 - 1];
        int i2 = 0;
        while (i2 < ng) {
            int j = 0;
            while (j < ng) {
                int n = i2 + j;
                pxpy[n] = pxpy[n] + mx[i2][j];
                ++j;
            }
            ++i2;
        }
        double[] pxmy = new double[ng];
        int i3 = 0;
        while (i3 < ng) {
            int j = 0;
            while (j < ng) {
                int n = Math.abs(i3 - j);
                pxmy[n] = pxmy[n] + mx[i3][j];
                ++j;
            }
            ++i3;
        }
        double result = 0.0;
        switch (index) {
            case 0: {
                int i4 = 0;
                while (i4 < ng) {
                    int j = 0;
                    while (j < ng) {
                        result += mx[i4][j] * mx[i4][j];
                        ++j;
                    }
                    ++i4;
                }
                break;
            }
            case 1: {
                int n = 1;
                while (n < ng) {
                    int v = n * n;
                    int i5 = 0;
                    while (i5 < ng) {
                        if (i5 - n >= 0) {
                            result += (double)v * mx[i5][i5 - n];
                        }
                        if (i5 + n < ng) {
                            result += (double)v * mx[i5][i5 + n];
                        }
                        ++i5;
                    }
                    ++n;
                }
                break;
            }
            case 2: {
                int j;
                double sd = 0.0;
                int i6 = 0;
                while (i6 < ng) {
                    double value = ((double)i6 - mu) * ((double)i6 - mu);
                    j = 0;
                    while (j < ng) {
                        sd += value * mx[i6][j];
                        ++j;
                    }
                    ++i6;
                }
                i6 = 0;
                while (i6 < ng) {
                    j = 0;
                    while (j < ng) {
                        result += (double)(i6 * j) * mx[i6][j];
                        ++j;
                    }
                    ++i6;
                }
                result = (result - mu * mu) / (sd * sd);
                break;
            }
            case 3: {
                int i7 = 0;
                while (i7 < ng) {
                    double value = ((double)i7 - mu) * ((double)i7 - mu);
                    int j = 0;
                    while (j < ng) {
                        result += value * mx[i7][j];
                        ++j;
                    }
                    ++i7;
                }
                break;
            }
            case 4: {
                int i8 = 0;
                while (i8 < ng) {
                    int j = 0;
                    while (j < ng) {
                        result += mx[i8][j] / (double)(1 + (i8 - j) * (i8 - j));
                        ++j;
                    }
                    ++i8;
                }
                break;
            }
            case 5: {
                int i9 = 0;
                while (i9 < pxpy.length) {
                    result += (double)(i9 + 2) * pxpy[i9];
                    ++i9;
                }
                break;
            }
            case 6: {
                double f8 = 0.0;
                int i10 = 0;
                while (i10 < pxpy.length) {
                    if (0.0 < pxpy[i10]) {
                        f8 -= pxpy[i10] * Math.log(pxpy[i10]);
                    }
                    ++i10;
                }
                i10 = 0;
                while (i10 < pxpy.length) {
                    if (0.0 < pxpy[i10]) {
                        result += ((double)(i10 + 2) - f8) * ((double)(i10 + 2) - f8) * pxpy[i10];
                    }
                    ++i10;
                }
                break;
            }
            case 7: {
                int i11 = 0;
                while (i11 < pxpy.length) {
                    if (0.0 < pxpy[i11]) {
                        result -= pxpy[i11] * Math.log(pxpy[i11]);
                    }
                    ++i11;
                }
                break;
            }
            case 8: {
                int i12 = 0;
                while (i12 < ng) {
                    int j = 0;
                    while (j < ng) {
                        if (0.0 < mx[i12][j]) {
                            result -= mx[i12][j] * Math.log(mx[i12][j]);
                        }
                        ++j;
                    }
                    ++i12;
                }
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                int i13 = 0;
                while (i13 < pxmy.length) {
                    if (0.0 < pxmy[i13]) {
                        result -= pxmy[i13] * Math.log(pxmy[i13]);
                    }
                    ++i13;
                }
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
        }
        return result;
    }

    public final int extractRegion4(boolean[] binaryMap, int[] resultMap) {
        this.neighborFrame.set4();
        return this.extractRegion(binaryMap, resultMap);
    }

    public final int extractRegion8(boolean[] binaryMap, int[] resultMap) {
        this.neighborFrame.set8();
        return this.extractRegion(binaryMap, resultMap);
    }

    private final int extractRegion(boolean[] binaryMap, int[] resultMap) {
        int start = 0;
        int background = start - 1;
        Arrays.fill(resultMap, background);
        int numberRegion = start;
        int pn = 0;
        while (pn < binaryMap.length) {
            if (binaryMap[pn] && resultMap[pn] == background) {
                resultMap[pn] = numberRegion;
                fifo.add(pn);
                do {
                    int cp = fifo.get();
                    int[] neighbor = this.neighborFrame.getExist(cp);
                    int i = 0;
                    while (i < neighbor.length) {
                        int cn = cp + neighbor[i];
                        if (binaryMap[cn] && resultMap[cn] == background) {
                            resultMap[cn] = numberRegion;
                            fifo.add(cn);
                        }
                        ++i;
                    }
                } while (fifo.getSize() > 0);
                ++numberRegion;
            }
            ++pn;
        }
        return numberRegion;
    }

    public final int makeConnectMap(int[][] connection, int[] map) {
        Arrays.fill(map, -1);
        int numberRegion = 0;
        int nHalf = this.neighborFrame.getNumber() / 2;
        int pn = 0;
        while (pn < this.neighborFrame.size) {
            int cn;
            int i;
            int[] neighbor;
            if (map[pn] == -1) {
                neighbor = this.neighborFrame.getDir(pn);
                i = 0;
                while (i < neighbor.length) {
                    cn = pn + neighbor[i];
                    if (this.checkConnection(pn, connection[pn], cn, connection[cn]) && map[cn] > -1) {
                        map[pn] = map[cn];
                        break;
                    }
                    ++i;
                }
            }
            if (map[pn] == -1) {
                int cp = pn;
                int direction = -1;
                block2: do {
                    if (map[cp] == -1) {
                        map[cp] = numberRegion;
                    }
                    neighbor = this.neighborFrame.getDir(cp);
                    i = 0;
                    while (i < neighbor.length) {
                        cn = cp + neighbor[direction = (direction + 1) % neighbor.length];
                        if (this.checkConnection(cp, connection[cp], cn, connection[cn])) {
                            cp = cn;
                            direction += nHalf;
                            continue block2;
                        }
                        ++i;
                    }
                } while (cp != pn);
                ++numberRegion;
            }
            ++pn;
        }
        return numberRegion;
    }

    private boolean checkConnection(int c, int[] cNeighbor, int n, int[] nNeighbor) {
        if (c == n) {
            return false;
        }
        int i = 0;
        while (i < cNeighbor.length) {
            if (cNeighbor[i] == n) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < nNeighbor.length) {
            if (nNeighbor[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int[] getHDome4(int h, int[] iMask) {
        int[] iMarker = new int[iMask.length];
        int pn = 0;
        while (pn < iMask.length) {
            iMarker[pn] = iMask[pn] - h;
            ++pn;
        }
        this.reconstruct4(iMask, iMarker);
        int[] result = new int[iMask.length];
        int pn2 = 0;
        while (pn2 < iMask.length) {
            result[pn2] = iMask[pn2] - iMarker[pn2];
            ++pn2;
        }
        return result;
    }

    public NeighborFrame getNeighborFrame() {
        return this.neighborFrame;
    }
}

