/*
 * Decompiled with CFR 0.152.
 */
package sos.pac;

import java.util.HashMap;
import sos.pac.IPACAbstraction;

public abstract class AbstractPACControl {
    protected static HashMap presentations = new HashMap();
    protected static HashMap<String, IPACAbstraction> models = new HashMap();
    protected IPACAbstraction model;
    protected AbstractPACControl parent;

    public AbstractPACControl(AbstractPACControl parent) {
        this.parent = parent;
        this.setModel();
        this.setPresentations();
    }

    protected void setModel() {
        String controlName = this.getClass().getName();
        String modelName = controlName.replaceFirst("Control", "Model");
        try {
            Class<?> modelClass = Class.forName(modelName);
            this.model = (IPACAbstraction)modelClass.newInstance();
            models.put(modelName, this.model);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected abstract void setPresentations();

    protected Object getPresentation(String name) {
        return this.get(presentations, name);
    }

    protected IPACAbstraction getAbstraction(String name) {
        return (IPACAbstraction)this.get(models, name);
    }

    private Object get(HashMap map, String name) throws NoClassDefFoundError {
        Object view = map.get(name);
        if (view != null) {
            return view;
        }
        throw new NoClassDefFoundError();
    }

    protected IPACAbstraction getParentModel() {
        return this.parent.model;
    }
}

