/*
 * Decompiled with CFR 0.152.
 */
package sos.math;

import sos.math.Statistics;

final class StatisticsArray {
    private Statistics[] sta;
    private int nCluster;
    private int[] minmax;

    public StatisticsArray(double[][] data, int n, int[] cluster) {
        this.nCluster = n;
        int[] nBelong = new int[n];
        int in = 0;
        while (in < data.length) {
            int n2 = cluster[in];
            nBelong[n2] = nBelong[n2] + 1;
            ++in;
        }
        double[][][] dataSeg = new double[n][][];
        int un = 0;
        while (un < n) {
            dataSeg[un] = new double[nBelong[un]][];
            ++un;
        }
        int in2 = 0;
        while (in2 < data.length) {
            int index;
            int n3 = index = cluster[in2];
            nBelong[n3] = nBelong[n3] - 1;
            dataSeg[index][nBelong[index]] = data[in2];
            ++in2;
        }
        this.sta = new Statistics[n];
        int un2 = 0;
        while (un2 < n) {
            this.sta[un2] = new Statistics(dataSeg[un2]);
            ++un2;
        }
    }

    public final void merge(int source, int destiny) {
        this.sta[destiny].addInput(this.sta[source].getInput());
        this.sta[source].reset();
    }

    public final int getNumber(int index) {
        return this.sta[index].nInput;
    }

    public final double[] getMean(int index) {
        return this.sta[index].getMean();
    }

    public final double[] getVariance(int index) {
        return this.sta[index].getVariance();
    }

    public final double[] getSD(int index) {
        return this.sta[index].getSD();
    }

    public final double[] getMin(int index) {
        return this.sta[index].getMin();
    }

    public final double[] getMax(int index) {
        return this.sta[index].getMax();
    }

    public final int getMin() {
        this.calcMinMax();
        return this.minmax[0];
    }

    public final int getMax() {
        this.calcMinMax();
        return this.minmax[1];
    }

    private final void calcMinMax() {
        if (this.minmax != null) {
            return;
        }
        double[] tempMin = this.sta[0].getMin();
        double[] tempMax = this.sta[0].getMax();
        this.minmax = new int[2];
        this.minmax[0] = (int)tempMin[0];
        this.minmax[1] = (int)tempMax[0];
        int un = 0;
        while (un < this.nCluster) {
            if (this.sta[un].nInput > 0) {
                tempMin = this.sta[un].getMin();
                tempMax = this.sta[un].getMax();
                int d = 0;
                while (d < 3) {
                    if ((int)tempMin[d] < this.minmax[0]) {
                        this.minmax[0] = (int)tempMin[d];
                    }
                    if ((int)tempMax[d] > this.minmax[1]) {
                        this.minmax[1] = (int)tempMax[d];
                    }
                    ++d;
                }
            }
            ++un;
        }
    }

    public final double[] getMidpoint(int index) {
        return this.sta[index].getMidpoint();
    }

    public final double[][] getEigenVector(int index) {
        return this.sta[index].getEigenVector();
    }

    public final double[][] getEigenValuedVector(int index) {
        return this.sta[index].getEigenValuedVector();
    }

    public final double[][] getRelativeCumHistogram(int index, int number) {
        return this.sta[index].getRelativeCumHistogram(number);
    }

    public final double[][] getRelativeCumHistogram(int index, int min, int max) {
        return this.sta[index].getRelativeCumHistogram(min, max);
    }
}

