/*
 * Decompiled with CFR 0.152.
 */
package sos.math;

import java.util.Arrays;
import sos.math.MathMatrix;

public final class Statistics {
    static final double LN2 = Math.log(2.0);
    int dim;
    int nInput;
    double[] mean;
    double[] variance;
    double[] sd;
    double[] min;
    double[] max;
    double[] midpoint;
    double[] eigenValue;
    double[] entropyBit;
    double[] entropyDigit;
    double[] conditionalEntropy;
    double[][] covarMx;
    double[][] correlMx;
    double[][] eigenVector;
    double[][] eigenValuedVector;
    double[][] relativeCumHistogram;
    int[][] histogram;
    int[][] cumHistogram;
    private double[][] input;

    public Statistics(double[][] data) {
        this.input = data;
        this.nInput = this.input.length;
        this.dim = this.input[0].length;
    }

    public final void reset() {
        this.input = null;
        this.nInput = 0;
    }

    public final double[][] getInput() {
        return this.input;
    }

    public final void addInput(double[][] additional) {
        double[][] newInput = new double[this.nInput + additional.length][this.dim];
        System.arraycopy(this.input, 0, newInput, 0, this.nInput);
        System.arraycopy(additional, 0, newInput, this.nInput, additional.length);
        this.input = newInput;
        this.nInput = this.input.length;
        this.clear();
    }

    public final void clear() {
        this.mean = null;
        this.variance = null;
        this.sd = null;
        this.min = null;
        this.max = null;
        this.midpoint = null;
        this.eigenValue = null;
        this.covarMx = null;
        this.correlMx = null;
        this.eigenVector = null;
        this.eigenValuedVector = null;
        this.relativeCumHistogram = null;
        this.histogram = null;
        this.cumHistogram = null;
        this.entropyBit = null;
        this.entropyDigit = null;
        this.conditionalEntropy = null;
    }

    public final double[] getMean() {
        if (this.mean != null) {
            return this.mean;
        }
        this.mean = new double[this.dim];
        int in = 0;
        while (in < this.nInput) {
            int d = 0;
            while (d < this.dim) {
                int n = d;
                this.mean[n] = this.mean[n] + this.input[in][d];
                ++d;
            }
            ++in;
        }
        int d = 0;
        while (d < this.dim) {
            int n = d++;
            this.mean[n] = this.mean[n] / (double)this.nInput;
        }
        return this.mean;
    }

    public final double[] getEntropyBit() {
        if (this.entropyBit != null) {
            return this.entropyBit;
        }
        this.getMean();
        int[] histogram = new int[2];
        this.entropyBit = new double[this.dim];
        int d = 0;
        while (d < this.dim) {
            Arrays.fill(histogram, 0);
            int in = 0;
            while (in < this.nInput) {
                if (this.input[in][d] <= this.mean[d]) {
                    histogram[0] = histogram[0] + 1;
                } else {
                    histogram[1] = histogram[1] + 1;
                }
                ++in;
            }
            this.entropyBit[d] = this.calcEntropy(histogram);
            ++d;
        }
        return this.entropyBit;
    }

    public final double getEntropyBit(int index, int[] neighbor) {
        if (this.conditionalEntropy != null && this.conditionalEntropy[index] > 0.0) {
            return this.conditionalEntropy[index];
        }
        if (this.conditionalEntropy == null) {
            this.conditionalEntropy = new double[this.dim];
            Arrays.fill(this.conditionalEntropy, -1.0);
        }
        this.getMean();
        int[][] map = new int[2][2];
        int in = 0;
        while (in < this.nInput) {
            int i = this.input[in][index] <= this.mean[index] ? 0 : 1;
            int j = this.input[neighbor[in]][index] <= this.mean[index] ? 0 : 1;
            int[] nArray = map[i];
            int n = j;
            nArray[n] = nArray[n] + 1;
            ++in;
        }
        this.conditionalEntropy[index] = this.calcEntropy(map);
        return this.conditionalEntropy[index];
    }

    public final double[] getEntropyDigit() {
        if (this.entropyDigit != null) {
            return this.entropyDigit;
        }
        this.calcMinMax();
        this.entropyDigit = new double[this.dim];
        this.getHistogram(10);
        int d = 0;
        while (d < this.dim) {
            this.entropyDigit[d] = this.calcEntropy(this.histogram[d]);
            ++d;
        }
        return this.entropyDigit;
    }

    private double calcEntropy(int[] histogram) {
        double entropy = 0.0;
        int h = 0;
        while (h < histogram.length) {
            double p = 1.0 * (double)histogram[h] / (double)this.nInput;
            if (p > 0.0) {
                entropy -= p * Math.log(p);
            }
            ++h;
        }
        return entropy /= LN2;
    }

    private double calcEntropy(int[][] map) {
        double entropyMarkov = 0.0;
        int i = 0;
        while (i < map.length) {
            int sum = 0;
            int j = 0;
            while (j < map[i].length) {
                sum += map[i][j];
                ++j;
            }
            if (sum > 0) {
                double entropyNeighbor = 0.0;
                j = 0;
                while (j < map[i].length) {
                    double piJ = 1.0 * (double)map[i][j] / (double)sum;
                    if (map[i][j] > 0) {
                        entropyNeighbor += -piJ * Math.log(piJ);
                    }
                    ++j;
                }
                entropyMarkov += entropyNeighbor * (double)sum / (double)this.nInput;
            }
            ++i;
        }
        return entropyMarkov /= LN2;
    }

    public final double[] getVariance() {
        if (this.variance != null) {
            return this.variance;
        }
        if (this.mean == null) {
            this.getMean();
        }
        this.variance = new double[this.dim];
        int in = 0;
        while (in < this.nInput) {
            int d = 0;
            while (d < this.dim) {
                int n = d;
                this.variance[n] = this.variance[n] + (this.mean[d] - this.input[in][d]) * (this.mean[d] - this.input[in][d]);
                ++d;
            }
            ++in;
        }
        int d = 0;
        while (d < this.dim) {
            int n = d++;
            this.variance[n] = this.variance[n] / (double)this.nInput;
        }
        return this.variance;
    }

    public final double[] getSD() {
        if (this.sd != null) {
            return this.sd;
        }
        if (this.variance == null) {
            this.getVariance();
        }
        this.sd = new double[this.dim];
        int d = 0;
        while (d < this.dim) {
            this.sd[d] = Math.sqrt(this.variance[d]);
            ++d;
        }
        return this.sd;
    }

    public final double[] getMin() {
        this.calcMinMax();
        return this.min;
    }

    public final double[] getMax() {
        this.calcMinMax();
        return this.max;
    }

    private final void calcMinMax() {
        if (this.min != null && this.max != null) {
            return;
        }
        this.min = new double[this.dim];
        this.max = new double[this.dim];
        int d = 0;
        while (d < this.dim) {
            this.min[d] = this.input[0][d];
            this.max[d] = this.input[0][d];
            ++d;
        }
        int in = 0;
        while (in < this.nInput) {
            int d2 = 0;
            while (d2 < this.dim) {
                if (this.input[in][d2] < this.min[d2]) {
                    this.min[d2] = this.input[in][d2];
                } else if (this.max[d2] < this.input[in][d2]) {
                    this.max[d2] = this.input[in][d2];
                }
                ++d2;
            }
            ++in;
        }
    }

    public final double[] getMidpoint() {
        if (this.min == null || this.max == null) {
            this.calcMinMax();
        }
        this.midpoint = new double[this.dim];
        int d = 0;
        while (d < this.dim) {
            this.midpoint[d] = (this.min[d] + this.max[d]) / 2.0;
            ++d;
        }
        return this.midpoint;
    }

    public final double[][] getCovariance() {
        int x;
        if (this.covarMx != null) {
            return this.covarMx;
        }
        this.getMean();
        this.covarMx = new double[this.dim][this.dim];
        double[] difVec = new double[this.dim];
        int n = 0;
        while (n < this.nInput) {
            int d = 0;
            while (d < this.dim) {
                difVec[d] = this.input[n][d] - this.mean[d];
                ++d;
            }
            int y = 0;
            while (y < this.dim) {
                int x2 = y;
                while (x2 < this.dim) {
                    double[] dArray = this.covarMx[y];
                    int n2 = x2;
                    dArray[n2] = dArray[n2] + difVec[y] * difVec[x2];
                    ++x2;
                }
                ++y;
            }
            ++n;
        }
        int y = 0;
        while (y < this.dim) {
            x = y;
            while (x < this.dim) {
                double[] dArray = this.covarMx[y];
                int n3 = x++;
                dArray[n3] = dArray[n3] / (double)this.nInput;
            }
            ++y;
        }
        y = 0;
        while (y < this.dim) {
            x = y + 1;
            while (x < this.dim) {
                this.covarMx[x][y] = this.covarMx[y][x];
                ++x;
            }
            ++y;
        }
        return this.covarMx;
    }

    public final double[][] getCorrelation() {
        if (this.correlMx != null) {
            return this.correlMx;
        }
        this.getCovariance();
        if (this.sd == null) {
            if (this.variance == null) {
                int d = 0;
                while (d < this.dim) {
                    this.variance[d] = this.covarMx[d][d];
                    ++d;
                }
            } else {
                this.getSD();
            }
        }
        this.correlMx = new double[this.dim][this.dim];
        int y = 0;
        while (y < this.dim) {
            int x = 0;
            while (x < this.dim) {
                this.correlMx[y][x] = this.covarMx[y][x] / (this.sd[y] * this.sd[x]);
                ++x;
            }
            ++y;
        }
        return this.correlMx;
    }

    public final double[] getEigenValue() {
        this.calcEigen();
        return this.eigenValue;
    }

    public final double[][] getEigenVector() {
        this.calcEigen();
        return this.eigenVector;
    }

    private final void calcEigen() {
        if (this.eigenValue != null && this.eigenVector != null) {
            return;
        }
        this.getCovariance();
        this.eigenValue = new double[this.dim];
        this.eigenVector = new double[this.dim][this.dim];
        double[][] mx = MathMatrix.copy(this.covarMx);
        MathMatrix.eigenJacobi(mx, this.eigenVector);
        int d = 0;
        while (d < this.dim) {
            this.eigenValue[d] = mx[d][d];
            ++d;
        }
    }

    public final double[][] getEigenValuedVector() {
        if (this.eigenValuedVector != null) {
            return this.eigenValuedVector;
        }
        this.calcEigen();
        this.eigenValuedVector = new double[this.dim][this.dim];
        int n = 0;
        while (n < this.dim) {
            double value = Math.sqrt(this.eigenValue[n]);
            int d = 0;
            while (d < this.dim) {
                this.eigenValuedVector[n][d] = this.eigenVector[n][d] * value;
                ++d;
            }
            ++n;
        }
        return this.eigenValuedVector;
    }

    public final int[][] getHistogram(int histMin, int histMax) {
        if (this.histogram != null) {
            return this.histogram;
        }
        int number = Math.abs(histMax - histMin) + 1;
        this.histogram = new int[this.dim][number];
        int in = 0;
        while (in < this.nInput) {
            int d = 0;
            while (d < this.dim) {
                int index = (int)this.input[in][d];
                if (index < histMin) {
                    index = histMin;
                } else if (histMax < index) {
                    index = histMax;
                }
                int[] nArray = this.histogram[d];
                int n = index - histMin;
                nArray[n] = nArray[n] + 1;
                ++d;
            }
            ++in;
        }
        return this.histogram;
    }

    public final int[][] getCumulativeHistogram(int histMin, int histMax) {
        if (this.cumHistogram != null) {
            return this.cumHistogram;
        }
        this.getHistogram(histMin, histMax);
        this.cumHistogram = new int[this.dim][];
        int d = 0;
        while (d < this.dim) {
            this.cumHistogram[d] = new int[this.histogram[d].length];
            this.cumHistogram[d][0] = this.histogram[d][0];
            int h = 1;
            while (h < this.histogram[d].length) {
                this.cumHistogram[d][h] = this.cumHistogram[d][h - 1] + this.histogram[d][h];
                ++h;
            }
            ++d;
        }
        return this.cumHistogram;
    }

    public final double[][] getRelativeCumHistogram(int histMin, int histMax) {
        if (this.relativeCumHistogram != null) {
            return this.relativeCumHistogram;
        }
        this.getCumulativeHistogram(histMin, histMax);
        this.relativeCumHistogram = new double[this.dim][];
        int d = 0;
        while (d < this.dim) {
            this.relativeCumHistogram[d] = new double[this.cumHistogram[d].length];
            int h = 0;
            while (h < this.cumHistogram[d].length) {
                this.relativeCumHistogram[d][h] = 1.0 * (double)this.cumHistogram[d][h] / (double)this.nInput;
                ++h;
            }
            ++d;
        }
        return this.relativeCumHistogram;
    }

    public final int[][] getHistogram(int number) {
        if (this.histogram != null && this.histogram[0].length == number) {
            return this.histogram;
        }
        this.calcMinMax();
        this.histogram = new int[this.dim][number];
        int d = 0;
        while (d < this.dim) {
            double classInterval = (this.max[d] - this.min[d]) / (double)number;
            int in = 0;
            while (in < this.nInput) {
                int classID = (int)((this.input[in][d] - this.min[d]) / classInterval);
                if (classID >= number) {
                    classID = number - 1;
                }
                int[] nArray = this.histogram[d];
                int n = classID;
                nArray[n] = nArray[n] + 1;
                ++in;
            }
            ++d;
        }
        return this.histogram;
    }

    public final int getMeanClass(int index) {
        return (int)((this.mean[index] - this.min[index]) * (double)this.histogram[index].length / (this.max[index] - this.min[index]));
    }

    public final int[][] getCumulativeHistogram(int number) {
        if (this.cumHistogram != null && this.cumHistogram[0].length == number) {
            return this.cumHistogram;
        }
        this.getHistogram(number);
        this.cumHistogram = new int[this.dim][number];
        int d = 0;
        while (d < this.dim) {
            this.cumHistogram[d][0] = this.histogram[d][0];
            int h = 1;
            while (h < number) {
                this.cumHistogram[d][h] = this.cumHistogram[d][h - 1] + this.histogram[d][h];
                ++h;
            }
            ++d;
        }
        return this.cumHistogram;
    }

    public final double[][] getRelativeCumHistogram(int number) {
        if (this.relativeCumHistogram != null && this.relativeCumHistogram[0].length == number) {
            return this.relativeCumHistogram;
        }
        this.getCumulativeHistogram(number);
        this.relativeCumHistogram = new double[this.dim][number];
        int d = 0;
        while (d < this.dim) {
            int h = 0;
            while (h < number) {
                this.relativeCumHistogram[d][h] = 1.0 * (double)this.cumHistogram[d][h] / (double)this.nInput;
                ++h;
            }
            ++d;
        }
        return this.relativeCumHistogram;
    }
}

