/*
 * Decompiled with CFR 0.152.
 */
package sos.math;

import java.awt.geom.Rectangle2D;

public final class MathVector {
    private static int distance;
    private static double distanceD;

    public static final void add(int[] vec1, int[] vec2) {
        int d = 0;
        while (d < vec1.length) {
            int n = d;
            vec1[n] = vec1[n] + vec2[d];
            ++d;
        }
    }

    public static final void add(double[] vec1, double[] vec2) {
        int d = 0;
        while (d < vec1.length) {
            int n = d;
            vec1[n] = vec1[n] + vec2[d];
            ++d;
        }
    }

    public static final void add(double[] vec1, int[] vec2) {
        int d = 0;
        while (d < vec1.length) {
            int n = d;
            vec1[n] = vec1[n] + (double)vec2[d];
            ++d;
        }
    }

    public static final void subtract(int[] vec1, int[] vec2) {
        int d = 0;
        while (d < vec1.length) {
            int n = d;
            vec1[n] = vec1[n] - vec2[d];
            ++d;
        }
    }

    public static final void subtract(double[] vec1, double[] vec2) {
        int d = 0;
        while (d < vec1.length) {
            int n = d;
            vec1[n] = vec1[n] - vec2[d];
            ++d;
        }
    }

    public static final void subtract(int[] vec1, int[] vec2, int[] result) {
        int d = 0;
        while (d < vec1.length) {
            result[d] = vec1[d] - vec2[d];
            ++d;
        }
    }

    public static final void subtract(double[] vec1, double[] vec2, double[] result) {
        int d = 0;
        while (d < vec1.length) {
            result[d] = vec1[d] - vec2[d];
            ++d;
        }
    }

    public static final void subtract(int[] vec1, double[] vec2, double[] result) {
        int d = 0;
        while (d < vec1.length) {
            result[d] = (double)vec1[d] - vec2[d];
            ++d;
        }
    }

    public static final int[] diff(int[] vec1, int[] vec2) {
        int[] result = new int[vec1.length];
        int d = 0;
        while (d < vec1.length) {
            result[d] = vec1[d] - vec2[d];
            ++d;
        }
        return result;
    }

    public static final double[] diff(double[] vec1, double[] vec2) {
        double[] result = new double[vec1.length];
        int d = 0;
        while (d < vec1.length) {
            result[d] = vec1[d] - vec2[d];
            ++d;
        }
        return result;
    }

    public static final double[] diff(int[] vec1, double[] vec2) {
        double[] result = new double[vec1.length];
        int d = 0;
        while (d < vec1.length) {
            result[d] = (double)vec1[d] - vec2[d];
            ++d;
        }
        return result;
    }

    public static final void scale(int[] vec, int value) {
        int d = 0;
        while (d < vec.length) {
            vec[d] = vec[d] * value;
            ++d;
        }
    }

    public static final void scale(int[] vec, double value) {
        int d = 0;
        while (d < vec.length) {
            vec[d] = (int)Math.round((double)vec[d] * value);
            ++d;
        }
    }

    public static final void scale(double[] vec, double value) {
        int d = 0;
        while (d < vec.length) {
            vec[d] = vec[d] * value;
            ++d;
        }
    }

    public static final int[] scaleD2I(double[] vec, double value) {
        int[] result = new int[vec.length];
        int d = 0;
        while (d < vec.length) {
            result[d] = (int)Math.round(vec[d] * value);
            ++d;
        }
        return result;
    }

    public static final double[] scaleI2D(int[] vec, double value) {
        double[] result = new double[vec.length];
        int d = 0;
        while (d < vec.length) {
            result[d] = (double)vec[d] * value;
            ++d;
        }
        return result;
    }

    public static final int[] divide(int[] vec, int value) {
        int[] result = new int[vec.length];
        int d = 0;
        while (d < vec.length) {
            result[d] = (int)Math.round(1.0 * (double)vec[d] / (double)value);
            ++d;
        }
        return result;
    }

    public static final int[] divide(int[] vec, double value) {
        int[] result = new int[vec.length];
        int d = 0;
        while (d < vec.length) {
            result[d] = (int)Math.round((double)vec[d] / value);
            ++d;
        }
        return result;
    }

    public static final double[] divide(double[] vec, double value) {
        double[] result = new double[vec.length];
        int d = 0;
        while (d < vec.length) {
            result[d] = vec[d] / value;
            ++d;
        }
        return result;
    }

    public static final int[] divideD2I(double[] vec, double value) {
        int[] result = new int[vec.length];
        int d = 0;
        while (d < vec.length) {
            result[d] = (int)Math.round(vec[d] / value);
            ++d;
        }
        return result;
    }

    public static final double[] divideI2D(int[] vec, double value) {
        double[] result = new double[vec.length];
        int d = 0;
        while (d < vec.length) {
            result[d] = (double)vec[d] / value;
            ++d;
        }
        return result;
    }

    public static final int dot(int[] vec1, int[] vec2) {
        int result = 0;
        int d = 0;
        while (d < vec1.length) {
            result += vec1[d] * vec2[d];
            ++d;
        }
        return result;
    }

    public static final double dot(double[] vec1, double[] vec2) {
        double result = 0.0;
        int d = 0;
        while (d < vec1.length) {
            result += vec1[d] * vec2[d];
            ++d;
        }
        return result;
    }

    public static final double dot(double[] vec1, int[] vec2) {
        double result = 0.0;
        int d = 0;
        while (d < vec1.length) {
            result += vec1[d] * (double)vec2[d];
            ++d;
        }
        return result;
    }

    public static final double length(int[] vec) {
        double result = 0.0;
        int d = 0;
        while (d < vec.length) {
            result += (double)(vec[d] * vec[d]);
            ++d;
        }
        return Math.sqrt(result);
    }

    public static final double length(double[] vec) {
        double result = 0.0;
        int d = 0;
        while (d < vec.length) {
            result += vec[d] * vec[d];
            ++d;
        }
        return Math.sqrt(result);
    }

    public static final int cross2d(int[] vec1, int[] vec2) {
        return vec1[0] * vec2[1] - vec1[1] * vec2[0];
    }

    public static final double cross2d(double[] vec1, double[] vec2) {
        return vec1[0] * vec2[1] - vec1[1] * vec2[0];
    }

    public static final double[] cross3d(double[] vec1, double[] vec2) {
        double[] result = new double[]{vec1[1] * vec2[2] - vec1[2] * vec2[1], vec1[2] * vec2[0] - vec1[0] * vec2[2], vec1[0] * vec2[1] - vec1[1] * vec2[0]};
        return result;
    }

    public static final double[] normalize(double[] vec) {
        return MathVector.divide(vec, MathVector.length(vec));
    }

    public static final int[] mean(int[][] vec) {
        int[] result = new int[vec[0].length];
        int n = 0;
        while (n < vec.length) {
            int d = 0;
            while (d < vec[0].length) {
                int n2 = d;
                result[n2] = result[n2] + vec[n][d];
                ++d;
            }
            ++n;
        }
        int d = 0;
        while (d < vec[0].length) {
            result[d] = (int)Math.round(1.0 * (double)result[d] / (double)vec.length);
            ++d;
        }
        return result;
    }

    public static final double[] meanI2D(int[][] vec) {
        double[] result = new double[vec[0].length];
        int n = 0;
        while (n < vec.length) {
            int d = 0;
            while (d < vec[0].length) {
                int n2 = d;
                result[n2] = result[n2] + (double)vec[n][d];
                ++d;
            }
            ++n;
        }
        int d = 0;
        while (d < vec[0].length) {
            result[d] = result[d] / (double)vec.length;
            ++d;
        }
        return result;
    }

    public static final double[] mean(double[][] vec) {
        double[] result = new double[vec[0].length];
        int n = 0;
        while (n < vec.length) {
            int d = 0;
            while (d < vec[0].length) {
                int n2 = d;
                result[n2] = result[n2] + vec[n][d];
                ++d;
            }
            ++n;
        }
        int d = 0;
        while (d < vec[0].length) {
            int n3 = d++;
            result[n3] = result[n3] / (double)vec.length;
        }
        return result;
    }

    public static final double[] mean(double[][] vec, int[] histogram) {
        double[] result = new double[vec[0].length];
        int total = 0;
        int n = 0;
        while (n < vec.length) {
            int d = 0;
            while (d < vec[0].length) {
                int n2 = d;
                result[n2] = result[n2] + vec[n][d];
                ++d;
            }
            total += histogram[n];
            ++n;
        }
        int d = 0;
        while (d < vec[0].length) {
            int n3 = d++;
            result[n3] = result[n3] / (double)total;
        }
        return result;
    }

    public static final double[] weightMean(double[][] vec, double[] alpha) {
        double[] result = new double[vec[0].length];
        int n = 0;
        while (n < vec.length) {
            int d = 0;
            while (d < result.length) {
                int n2 = d;
                result[n2] = result[n2] + alpha[n] * vec[n][d];
                ++d;
            }
            ++n;
        }
        return result;
    }

    public static final double[] weightMean(double[] vec1, double[] vec2, double r1, double r2) {
        double[] result = new double[vec1.length];
        double r = r1 + r2;
        int d = 0;
        while (d < vec1.length) {
            result[d] = (r1 * vec1[d] + r2 * vec2[d]) / r;
            ++d;
        }
        return result;
    }

    public static final int[] weightMean(int[] vec1, int[] vec2, double r1, double r2) {
        int[] result = new int[vec1.length];
        double r = r1 + r2;
        int d = 0;
        while (d < vec1.length) {
            result[d] = (int)Math.round((r1 * (double)vec1[d] + r2 * (double)vec2[d]) / r);
            ++d;
        }
        return result;
    }

    public static final int blockDistance(int[] vec1, int[] vec2) {
        distance = 0;
        int d = 0;
        while (d < vec1.length) {
            distance += Math.abs(vec1[d] - vec2[d]);
            ++d;
        }
        return distance;
    }

    public static final double blockDistance(double[] vec1, double[] vec2) {
        distanceD = 0.0;
        int d = 0;
        while (d < vec1.length) {
            distanceD += Math.abs(vec1[d] - vec2[d]);
            ++d;
        }
        return distanceD;
    }

    public static final int norm(int[] vec1, int[] vec2) {
        distance = 0;
        int d = 0;
        while (d < vec1.length) {
            distance += (vec1[d] - vec2[d]) * (vec1[d] - vec2[d]);
            ++d;
        }
        return distance;
    }

    public static final double norm(double[] vec1, double[] vec2) {
        distanceD = 0.0;
        int d = 0;
        while (d < vec1.length) {
            distanceD += (vec1[d] - vec2[d]) * (vec1[d] - vec2[d]);
            ++d;
        }
        return distanceD;
    }

    public static final int normSum(int[][] vec1, int[][] vec2) {
        distance = 0;
        int n = 0;
        while (n < vec1.length) {
            int d = 0;
            while (d < vec1[0].length) {
                distance += (vec1[n][d] - vec2[n][d]) * (vec1[n][d] - vec2[n][d]);
                ++d;
            }
            ++n;
        }
        return distance;
    }

    public static final double normSum(double[][] vec1, double[][] vec2) {
        distanceD = 0.0;
        int n = 0;
        while (n < vec1.length) {
            int d = 0;
            while (d < vec1[0].length) {
                distanceD += (vec1[n][d] - vec2[n][d]) * (vec1[n][d] - vec2[n][d]);
                ++d;
            }
            ++n;
        }
        return distanceD;
    }

    public static final double normSum(double[][] vec1, double[] vec2) {
        distanceD = 0.0;
        int n = 0;
        while (n < vec1.length) {
            int d = 0;
            while (d < vec2.length) {
                distanceD += (vec1[n][d] - vec2[d]) * (vec1[n][d] - vec2[d]);
                ++d;
            }
            ++n;
        }
        return distanceD;
    }

    public static final double cos(int[] vec1, int[] vec2) {
        int d1 = MathVector.dot(vec1, vec1);
        int d2 = MathVector.dot(vec2, vec2);
        double result = (double)MathVector.dot(vec1, vec2) / (Math.sqrt(d1) * Math.sqrt(d2));
        return result;
    }

    public static final double cos(int[] vec1, int[] vec2, int[] center1, int[] center2) {
        return MathVector.cos(MathVector.diff(vec1, center1), MathVector.diff(vec2, center2));
    }

    public static final double cos(double[] vec1, double[] vec2) {
        double d1 = MathVector.dot(vec1, vec1);
        double d2 = MathVector.dot(vec2, vec2);
        double result = MathVector.dot(vec1, vec2) / (Math.sqrt(d1) * Math.sqrt(d2));
        return result;
    }

    public static final double cos(double[] vec1, double[] vec2, double[] center) {
        return MathVector.cos(MathVector.diff(vec1, center), MathVector.diff(vec2, center));
    }

    public static final int[][] zeroSet(int[][] vec1, int[] vec2) {
        int[][] result = new int[vec1.length][vec2.length];
        int n = 0;
        while (n < vec1.length) {
            int d = 0;
            while (d < vec2.length) {
                result[n][d] = vec1[n][d] - vec2[d];
                ++d;
            }
            ++n;
        }
        return result;
    }

    public static final double[][] zeroSet(double[][] vec1, double[] vec2) {
        double[][] result = new double[vec1.length][vec2.length];
        int n = 0;
        while (n < vec1.length) {
            int d = 0;
            while (d < vec2.length) {
                result[n][d] = vec1[n][d] - vec2[d];
                ++d;
            }
            ++n;
        }
        return result;
    }

    public static final int[] merge(int[] vec1, int[] vec2) {
        int[] result = new int[vec1.length + vec2.length];
        System.arraycopy(vec1, 0, result, 0, vec1.length);
        System.arraycopy(vec2, 0, result, vec1.length, vec2.length);
        return result;
    }

    public static final int[] doubleToInt(double[] vec) {
        int[] result = new int[vec.length];
        int d = 0;
        while (d < vec.length) {
            result[d] = (int)Math.round(vec[d]);
            ++d;
        }
        return result;
    }

    public static final double[][] covariance(double[][] vec) {
        int x;
        int dim = vec[0].length;
        double[] mean = MathVector.mean(vec);
        double[] difVec = new double[dim];
        double[][] covMx = new double[dim][dim];
        int n = 0;
        while (n < vec.length) {
            int d = 0;
            while (d < dim) {
                difVec[d] = vec[n][d] - mean[d];
                ++d;
            }
            int y = 0;
            while (y < dim) {
                int x2 = y;
                while (x2 < dim) {
                    double[] dArray = covMx[y];
                    int n2 = x2;
                    dArray[n2] = dArray[n2] + difVec[y] * difVec[x2];
                    ++x2;
                }
                ++y;
            }
            ++n;
        }
        int y = 0;
        while (y < dim) {
            x = y;
            while (x < dim) {
                double[] dArray = covMx[y];
                int n3 = x++;
                dArray[n3] = dArray[n3] / (double)vec.length;
            }
            ++y;
        }
        y = 0;
        while (y < dim) {
            x = y + 1;
            while (x < dim) {
                covMx[x][y] = covMx[y][x];
                ++x;
            }
            ++y;
        }
        return covMx;
    }

    public static final double[][][] covariance(double[][] vec, int[] cluster, int nCluster) {
        int x;
        int y;
        int dim = vec[0].length;
        double[][] mean = new double[nCluster][dim];
        int[] nBelongs = new int[nCluster];
        int n = 0;
        while (n < cluster.length) {
            MathVector.add(mean[cluster[n]], vec[n]);
            int n2 = cluster[n];
            nBelongs[n2] = nBelongs[n2] + 1;
            ++n;
        }
        int i = 0;
        while (i < nCluster) {
            mean[i] = MathVector.divide(mean[i], (double)nBelongs[i]);
            ++i;
        }
        double[] difVec = new double[dim];
        double[][][] covMx = new double[nCluster][dim][dim];
        int n3 = 0;
        while (n3 < vec.length) {
            int d = 0;
            while (d < dim) {
                difVec[d] = vec[n3][d] - mean[cluster[n3]][d];
                ++d;
            }
            y = 0;
            while (y < dim) {
                x = y;
                while (x < dim) {
                    double[] dArray = covMx[cluster[n3]][y];
                    int n4 = x;
                    dArray[n4] = dArray[n4] + difVec[y] * difVec[x];
                    ++x;
                }
                ++y;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < nCluster) {
            y = 0;
            while (y < dim) {
                x = y;
                while (x < dim) {
                    double[] dArray = covMx[n3][y];
                    int n5 = x++;
                    dArray[n5] = dArray[n5] / (double)nBelongs[n3];
                }
                ++y;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < nCluster) {
            y = 0;
            while (y < dim) {
                x = y + 1;
                while (x < dim) {
                    covMx[n3][x][y] = covMx[n3][y][x];
                    ++x;
                }
                ++y;
            }
            ++n3;
        }
        return covMx;
    }

    public static final double[][] covariance(double[] vec, int dim) {
        int x;
        int length = vec.length / dim;
        double[] mean = new double[dim];
        int n = 0;
        while (n < vec.length) {
            int d = 0;
            while (d < dim) {
                int n2 = d;
                mean[n2] = mean[n2] + vec[n + d];
                ++d;
            }
            n += dim;
        }
        int d = 0;
        while (d < dim) {
            int n3 = d++;
            mean[n3] = mean[n3] / (double)length;
        }
        double[] difVec = new double[dim];
        double[][] covMx = new double[dim][dim];
        int n4 = 0;
        while (n4 < vec.length) {
            int d2 = 0;
            while (d2 < dim) {
                difVec[d2] = vec[n4 + d2] - mean[d2];
                ++d2;
            }
            int y = 0;
            while (y < dim) {
                int x2 = y;
                while (x2 < dim) {
                    double[] dArray = covMx[y];
                    int n5 = x2;
                    dArray[n5] = dArray[n5] + difVec[y] * difVec[x2];
                    ++x2;
                }
                ++y;
            }
            n4 += dim;
        }
        int y = 0;
        while (y < dim) {
            x = y;
            while (x < dim) {
                double[] dArray = covMx[y];
                int n6 = x++;
                dArray[n6] = dArray[n6] / (double)length;
            }
            ++y;
        }
        y = 0;
        while (y < dim) {
            x = y + 1;
            while (x < dim) {
                covMx[x][y] = covMx[y][x];
                ++x;
            }
            ++y;
        }
        return covMx;
    }

    public static final double[][] corelations(double[] vec, int dim) {
        int x;
        int length = vec.length / dim;
        double[] mean = new double[dim];
        int n = 0;
        while (n < vec.length) {
            int d = 0;
            while (d < dim) {
                int n2 = d;
                mean[n2] = mean[n2] + vec[n + d];
                ++d;
            }
            n += dim;
        }
        int d = 0;
        while (d < dim) {
            int n3 = d++;
            mean[n3] = mean[n3] / (double)length;
        }
        double[] difVec = new double[dim];
        double[][] covMx = new double[dim][dim];
        int n4 = 0;
        while (n4 < vec.length) {
            int d2 = 0;
            while (d2 < dim) {
                difVec[d2] = vec[n4 + d2] - mean[d2];
                ++d2;
            }
            int y = 0;
            while (y < dim) {
                int x2 = y;
                while (x2 < dim) {
                    double[] dArray = covMx[y];
                    int n5 = x2;
                    dArray[n5] = dArray[n5] + difVec[y] * difVec[x2];
                    ++x2;
                }
                ++y;
            }
            n4 += dim;
        }
        int y = 0;
        while (y < dim) {
            x = y;
            while (x < dim) {
                if (y != x) {
                    double[] dArray = covMx[y];
                    int n6 = x;
                    dArray[n6] = dArray[n6] / ((double)length * Math.sqrt(covMx[y][y]) * Math.sqrt(covMx[x][x]));
                }
                ++x;
            }
            ++y;
        }
        int i = 0;
        while (i < dim) {
            covMx[i][i] = 1.0;
            ++i;
        }
        y = 0;
        while (y < dim) {
            x = y + 1;
            while (x < dim) {
                covMx[x][y] = covMx[y][x];
                ++x;
            }
            ++y;
        }
        return covMx;
    }

    public static final double[][] covariance(int[][] vec) {
        int x;
        int dim = vec[0].length;
        double[] mean = MathVector.meanI2D(vec);
        double[] difVec = new double[dim];
        double[][] covMx = new double[dim][dim];
        int n = 0;
        while (n < vec.length) {
            int d = 0;
            while (d < dim) {
                difVec[d] = (double)vec[n][d] - mean[d];
                ++d;
            }
            int y = 0;
            while (y < dim) {
                int x2 = y;
                while (x2 < dim) {
                    double[] dArray = covMx[y];
                    int n2 = x2;
                    dArray[n2] = dArray[n2] + difVec[y] * difVec[x2];
                    ++x2;
                }
                ++y;
            }
            ++n;
        }
        int y = 0;
        while (y < dim) {
            x = y;
            while (x < dim) {
                double[] dArray = covMx[y];
                int n3 = x++;
                dArray[n3] = dArray[n3] / (double)vec.length;
            }
            ++y;
        }
        y = 0;
        while (y < dim) {
            x = y + 1;
            while (x < dim) {
                covMx[x][y] = covMx[y][x];
                ++x;
            }
            ++y;
        }
        return covMx;
    }

    public static final Rectangle2D.Double getBounds(double[][] data) {
        double[][] rect = new double[2][2];
        int xy = 0;
        while (xy < 2) {
            rect[xy][0] = data[xy][0];
            rect[xy][1] = data[xy][0];
            int pn = 1;
            while (pn < data[xy].length) {
                if (data[xy][pn] < rect[xy][0]) {
                    rect[xy][0] = data[xy][pn];
                } else if (data[xy][pn] > rect[xy][1]) {
                    rect[xy][1] = data[xy][pn];
                }
                ++pn;
            }
            ++xy;
        }
        return new Rectangle2D.Double(rect[0][0], rect[1][0], rect[0][1] - rect[0][0], rect[1][1] - rect[1][0]);
    }

    public static final double radian(double[] vec) {
        double theta = Math.acos(vec[0] / Math.sqrt(vec[0] * vec[0] + vec[1] * vec[1]));
        if (vec[1] < 0.0) {
            theta = Math.PI * 2 - theta;
        }
        return theta;
    }
}

