/*
 * Decompiled with CFR 0.152.
 */
package sos.math;

public final class MathMatrix {
    static final double EPS = 1.0E-16;
    static final double TINY = 1.0E-32;
    static final int MAX_ITER = 30000;

    public static final void copy(double[][] source, double[][] dist) {
        int y = 0;
        while (y < source.length) {
            System.arraycopy(source[y], 0, dist[y], 0, source[y].length);
            ++y;
        }
    }

    public static final double[][] copy(double[][] mx) {
        double[][] newMx = new double[mx.length][mx[0].length];
        MathMatrix.copy(mx, newMx);
        return newMx;
    }

    public static final void clear(double[][] mx) {
        int y = 0;
        while (y < mx.length) {
            int x = 0;
            while (x < mx[0].length) {
                mx[y][x] = 0.0;
                ++x;
            }
            ++y;
        }
    }

    public static final void toUnit(double[][] mx, double alfa) {
        MathMatrix.clear(mx);
        int y = 0;
        while (y < mx.length) {
            mx[y][y] = alfa;
            ++y;
        }
    }

    public static final int[][] transpose(int[][] mx) {
        int[][] result = new int[mx[0].length][mx.length];
        int y = 0;
        while (y < mx.length) {
            int x = 0;
            while (x < mx[0].length) {
                result[x][y] = mx[y][x];
                ++x;
            }
            ++y;
        }
        return result;
    }

    public static final double[][] transpose(double[][] mx) {
        double[][] result = new double[mx[0].length][mx.length];
        int y = 0;
        while (y < mx.length) {
            int x = 0;
            while (x < mx[0].length) {
                result[x][y] = mx[y][x];
                ++x;
            }
            ++y;
        }
        return result;
    }

    public static final double[][] exchangeRow(double[][] mx) {
        if (mx.length != 2) {
            return null;
        }
        double[][] newMx = new double[2][];
        newMx[1] = mx[0];
        newMx[0] = mx[1];
        return newMx;
    }

    public static final void exchangeRow(int i, int j, double[][] mx) {
        double[] temp = mx[i];
        mx[i] = mx[j];
        mx[j] = temp;
    }

    public static final void add(int[][] mx1, int[][] mx2) {
        int y = 0;
        while (y < mx1.length) {
            int x = 0;
            while (x < mx1[0].length) {
                int[] nArray = mx1[y];
                int n = x;
                nArray[n] = nArray[n] + mx2[y][x];
                ++x;
            }
            ++y;
        }
    }

    public static final void add(double[][] mx1, double[][] mx2) {
        int y = 0;
        while (y < mx1.length) {
            int x = 0;
            while (x < mx1[0].length) {
                double[] dArray = mx1[y];
                int n = x;
                dArray[n] = dArray[n] + mx2[y][x];
                ++x;
            }
            ++y;
        }
    }

    public static final void scale(double[][] mx, double value) {
        int y = 0;
        while (y < mx.length) {
            int x = 0;
            while (x < mx[0].length) {
                double[] dArray = mx[y];
                int n = x++;
                dArray[n] = dArray[n] * value;
            }
            ++y;
        }
    }

    public static final void scaleDivide(int[][] mx, int value) {
        int y = 0;
        while (y < mx.length) {
            int x = 0;
            while (x < mx[0].length) {
                mx[y][x] = (int)Math.round(1.0 * (double)mx[y][x] / (double)value);
                ++x;
            }
            ++y;
        }
    }

    public static final void scaleDivide(double[][] mx, double value) {
        int y = 0;
        while (y < mx.length) {
            int x = 0;
            while (x < mx[0].length) {
                double[] dArray = mx[y];
                int n = x++;
                dArray[n] = dArray[n] / value;
            }
            ++y;
        }
    }

    public static final double[][] harmonicMean(double[][] mx1, double[][] mx2, double r1, double r2) {
        double[][] result = new double[mx1.length][mx1[0].length];
        double r = r1 + r2;
        int y = 0;
        while (y < mx1.length) {
            int x = 0;
            while (x < mx1[0].length) {
                result[y][x] = (r1 * mx1[y][x] + r2 * mx2[y][x]) / r;
                ++x;
            }
            ++y;
        }
        return result;
    }

    public static final double[][] random(double[][] mx) {
        double[][] result = new double[mx.length][mx[0].length];
        int y = 0;
        while (y < mx.length) {
            int x = 0;
            while (x < mx[0].length) {
                result[y][x] = mx[y][x] * (0.2 * Math.random() + 0.9);
                ++x;
            }
            ++y;
        }
        return result;
    }

    public static final double[] multiple(double[] vec, double[][] mx) {
        double[] result = new double[vec.length];
        MathMatrix.multiple(vec, mx, result);
        return result;
    }

    public static final void multiple(double[] vec, double[][] mx, double[] result) {
        int i = 0;
        while (i < mx[0].length) {
            double value = 0.0;
            int j = 0;
            while (j < mx.length) {
                value += vec[j] * mx[j][i];
                ++j;
            }
            result[i] = value;
            ++i;
        }
    }

    public static final void multiple(int[] vec, double[][] mx, double[] result) {
        int i = 0;
        while (i < mx[0].length) {
            double value = 0.0;
            int j = 0;
            while (j < mx.length) {
                value += (double)vec[j] * mx[j][i];
                ++j;
            }
            result[i] = value;
            ++i;
        }
    }

    public static final void multiple(double[][] mx, int[] vec, double[] result) {
        int y = 0;
        while (y < mx.length) {
            double value = 0.0;
            int x = 0;
            while (x < mx[0].length) {
                value += (double)vec[x] * mx[y][x];
                ++x;
            }
            result[y] = value;
            ++y;
        }
    }

    public static final void multiple(double[] vec, double[][] mx, int[] result) {
        int i = 0;
        while (i < mx[0].length) {
            double value = 0.0;
            int j = 0;
            while (j < mx.length) {
                value += vec[j] * mx[j][i];
                ++j;
            }
            result[i] = (int)Math.round(value);
            ++i;
        }
    }

    public static final void multiple(int[] vec, double[][] mx, int[] result) {
        if (vec == result) {
            int[] dist = new int[vec.length];
            MathMatrix.multiple(vec, mx, dist);
            result = dist;
        }
        int i = 0;
        while (i < mx[0].length) {
            double value = 0.0;
            int j = 0;
            while (j < mx.length) {
                value += (double)vec[j] * mx[j][i];
                ++j;
            }
            result[i] = (int)Math.round(value);
            ++i;
        }
    }

    public static final double[][] multiple(double[][] mx1, double[][] mx2) {
        double[][] result = new double[mx1.length][mx2[0].length];
        MathMatrix.multiple(mx1, mx2, result);
        return result;
    }

    public static final void multiple(double[][] mx1, double[][] mx2, double[][] result) {
        int y = 0;
        while (y < result.length) {
            int x = 0;
            while (x < result[y].length) {
                result[y][x] = 0.0;
                int i = 0;
                while (i < mx1[y].length) {
                    double[] dArray = result[y];
                    int n = x;
                    dArray[n] = dArray[n] + mx1[y][i] * mx2[i][x];
                    ++i;
                }
                ++x;
            }
            ++y;
        }
    }

    public static final int[][] multiple(int[][] mx1, int[][] mx2) {
        int[][] result = new int[mx1.length][mx2[0].length];
        int y = 0;
        while (y < result.length) {
            int x = 0;
            while (x < result[y].length) {
                int value = 0;
                int i = 0;
                while (i < mx1[y].length) {
                    value += mx1[y][i] * mx2[i][x];
                    ++i;
                }
                result[y][x] = value;
                ++x;
            }
            ++y;
        }
        return result;
    }

    public static final int[][] multiple(int[][] mx1, double[][] mx2) {
        int[][] result = new int[mx1.length][mx2[0].length];
        int y = 0;
        while (y < result.length) {
            int x = 0;
            while (x < result[y].length) {
                double value = 0.0;
                int i = 0;
                while (i < mx1[y].length) {
                    value += (double)mx1[y][i] * mx2[i][x];
                    ++i;
                }
                result[y][x] = (int)Math.round(value);
                ++x;
            }
            ++y;
        }
        return result;
    }

    public static final double inverse(double[][] originalMx, double[][] iMx) {
        double[][] mx = new double[originalMx.length][originalMx[0].length];
        MathMatrix.copy(originalMx, mx);
        MathMatrix.clear(iMx);
        int nRow = mx.length;
        int[] rowOrder = new int[nRow];
        double det = MathMatrix.lu(mx, rowOrder);
        if (det == 0.0) {
            return 0.0;
        }
        int x = 0;
        while (x < nRow) {
            int j;
            double value;
            int row;
            int y = 0;
            while (y < nRow) {
                row = rowOrder[y];
                value = row == x ? 1.0 : 0.0;
                j = 0;
                while (j < y) {
                    value -= mx[row][j] * iMx[j][x];
                    ++j;
                }
                iMx[y][x] = value;
                ++y;
            }
            y = nRow - 1;
            while (y >= 0) {
                value = iMx[y][x];
                row = rowOrder[y];
                j = y + 1;
                while (j < nRow) {
                    value -= mx[row][j] * iMx[j][x];
                    ++j;
                }
                iMx[y][x] = value / mx[row][y];
                --y;
            }
            ++x;
        }
        return det;
    }

    private static final double lu(double[][] mx, int[] rowOrder) {
        double value;
        double sentinel;
        int nRow = mx.length;
        double[] weight = new double[nRow];
        int y = 0;
        while (y < nRow) {
            rowOrder[y] = y;
            sentinel = 0.0;
            int x = 0;
            while (x < nRow) {
                value = Math.abs(mx[y][x]);
                if (value > sentinel) {
                    sentinel = value;
                }
                ++x;
            }
            if (sentinel == 0.0) {
                return 0.0;
            }
            weight[y] = 1.0 / sentinel;
            ++y;
        }
        double det = 1.0;
        int y2 = 0;
        int m = nRow;
        while (y2 < nRow) {
            int ii;
            sentinel = -1.0;
            int i = y2;
            while (i < nRow) {
                ii = rowOrder[i];
                value = Math.abs(mx[ii][y2]) * weight[ii];
                if (value > sentinel) {
                    sentinel = value;
                    m = i;
                }
                ++i;
            }
            int iy = rowOrder[m];
            if (m != y2) {
                rowOrder[m] = rowOrder[y2];
                rowOrder[y2] = iy;
                det = -det;
            }
            sentinel = mx[iy][y2];
            det *= sentinel;
            if (sentinel == 0.0) {
                return 0.0;
            }
            i = y2 + 1;
            while (i < nRow) {
                ii = rowOrder[i];
                double[] dArray = mx[ii];
                int n = y2;
                dArray[n] = dArray[n] / sentinel;
                value = mx[ii][y2];
                int x = y2 + 1;
                while (x < nRow) {
                    double[] dArray2 = mx[ii];
                    int n2 = x;
                    dArray2[n2] = dArray2[n2] - value * mx[iy][x];
                    ++x;
                }
                ++i;
            }
            ++y2;
        }
        return det;
    }

    public static boolean eigenJacobi(double[][] a, double[][] w) {
        double t;
        int k;
        int n = a.length;
        double s = 0.0;
        double offdiag = 0.0;
        int j = 0;
        while (j < n) {
            int k2 = 0;
            while (k2 < n) {
                w[j][k2] = 0.0;
                ++k2;
            }
            w[j][j] = 1.0;
            s += a[j][j] * a[j][j];
            k2 = j + 1;
            while (k2 < n) {
                offdiag += a[j][k2] * a[j][k2];
                ++k2;
            }
            ++j;
        }
        double tolerance = 9.999999999999999E-33 * (s / 2.0 + offdiag);
        int iter = 1;
        while (iter <= 30000) {
            offdiag = 0.0;
            int j2 = 0;
            while (j2 < n - 1) {
                k = j2 + 1;
                while (k < n) {
                    offdiag += a[j2][k] * a[j2][k];
                    ++k;
                }
                ++j2;
            }
            if (offdiag < tolerance) break;
            j2 = 0;
            while (j2 < n - 1) {
                k = j2 + 1;
                while (k < n) {
                    if (!(Math.abs(a[j2][k]) < 1.0E-32)) {
                        t = (a[k][k] - a[j2][j2]) / (2.0 * a[j2][k]);
                        t = t >= 0.0 ? 1.0 / (t + Math.sqrt(t * t + 1.0)) : 1.0 / (t - Math.sqrt(t * t + 1.0));
                        double c = 1.0 / Math.sqrt(t * t + 1.0);
                        double u = t * c;
                        double[] dArray = a[j2];
                        int n2 = j2;
                        dArray[n2] = dArray[n2] - (t *= a[j2][k]);
                        double[] dArray2 = a[k];
                        int n3 = k;
                        dArray2[n3] = dArray2[n3] + t;
                        a[j2][k] = 0.0;
                        int i = 0;
                        while (i < j2) {
                            MathMatrix.rotate(a, i, j2, i, k, c, u);
                            ++i;
                        }
                        i = j2 + 1;
                        while (i < k) {
                            MathMatrix.rotate(a, j2, i, i, k, c, u);
                            ++i;
                        }
                        i = k + 1;
                        while (i < n) {
                            MathMatrix.rotate(a, j2, i, k, i, c, u);
                            ++i;
                        }
                        i = 0;
                        while (i < n) {
                            MathMatrix.rotate(w, j2, i, k, i, c, u);
                            ++i;
                        }
                    }
                    ++k;
                }
                ++j2;
            }
            ++iter;
        }
        if (iter > 30000) {
            return false;
        }
        int i = 0;
        while (i < n - 1) {
            k = i;
            t = a[k][k];
            int j3 = i + 1;
            while (j3 < n) {
                if (a[j3][j3] > t) {
                    k = j3;
                    t = a[k][k];
                }
                ++j3;
            }
            a[k][k] = a[i][i];
            a[i][i] = t;
            double[] v = w[k];
            w[k] = w[i];
            w[i] = v;
            ++i;
        }
        return true;
    }

    private static void rotate(double[][] a, int i, int j, int k, int l, double c, double s) {
        double x = a[i][j];
        double y = a[k][l];
        a[i][j] = x * c - y * s;
        a[k][l] = x * s + y * c;
    }
}

