/*
 * Decompiled with CFR 0.152.
 */
package sos.math;

import javax.swing.JPanel;
import sos.image.ImageInfo;
import sos.math.Unit;
import sos.util.Sets;

public abstract class Clustering {
    protected int dim;
    protected int nInput;
    protected double[][] inputD;
    protected int[] cluster;
    protected int nUnit;
    protected Unit[] units;
    protected double evaluatedValue = Double.POSITIVE_INFINITY;
    protected double desiredValue;
    protected JPanel optionPanel;

    public String toString() {
        return this.getClass().getName();
    }

    public abstract void setParameters(ImageInfo var1);

    public abstract void calculate();

    public abstract boolean isConvoluted();

    public void setInput(double[][] i) {
        this.inputD = i;
        this.nInput = i.length;
        this.cluster = new int[this.nInput];
        this.dim = this.inputD[0].length;
    }

    public final void setUnit(double[][] u) {
        this.nUnit = u.length;
        this.units = new Unit[this.nUnit];
        int un = 0;
        while (un < this.nUnit) {
            this.units[un] = new Unit(this.dim);
            System.arraycopy(u[un], 0, this.units[un].mean, 0, this.dim);
            ++un;
        }
    }

    public final int getNUnit() {
        return this.nUnit;
    }

    public final double getNumber(int index) {
        return this.units[index].nBelong;
    }

    public final double[][] getCopyOfUnitD() {
        double[][] result = new double[this.nUnit][this.dim];
        int un = 0;
        while (un < this.nUnit) {
            int d = 0;
            while (d < this.dim) {
                result[un][d] = this.units[un].mean[d];
                ++d;
            }
            ++un;
        }
        return result;
    }

    public final int[][] getMean() {
        int[][] meanInt = new int[this.nUnit][this.dim];
        int un = 0;
        while (un < this.nUnit) {
            int d = 0;
            while (d < this.dim) {
                meanInt[un][d] = (int)Math.round(this.units[un].mean[d]);
                ++d;
            }
            ++un;
        }
        return meanInt;
    }

    public final int[] getMean(int index) {
        int[] meanInt = new int[this.dim];
        int d = 0;
        while (d < this.dim) {
            meanInt[d] = (int)Math.round(this.units[index].mean[d]);
            ++d;
        }
        return meanInt;
    }

    public final double[][] getMeanD() {
        double[][] result = new double[this.nUnit][];
        int un = 0;
        while (un < this.nUnit) {
            result[un] = this.units[un].mean;
            ++un;
        }
        return result;
    }

    public final double[] getMeanD(int index) {
        return this.units[index].mean;
    }

    protected final void calcMean(boolean needBackup) {
        int un;
        if (needBackup) {
            un = 0;
            while (un < this.nUnit) {
                this.units[un].backupMean();
                ++un;
            }
        }
        this.evaluatedValue = 0.0;
        un = 0;
        while (un < this.nUnit) {
            this.units[un].calcMean();
            this.evaluatedValue += this.units[un].calcMeanDifference();
            ++un;
        }
    }

    public final void setCluster(int[] cluster) {
        this.cluster = cluster;
    }

    public final void setCluster(int index, int value) {
        this.cluster[index] = value;
    }

    public final int[] getCluster() {
        return this.cluster;
    }

    public void sortUnits(int[] order) {
        Unit[] newUnits = new Unit[this.nUnit];
        int un = 0;
        while (un < this.nUnit) {
            newUnits[un] = this.units[order[un]];
            ++un;
        }
        this.units = newUnits;
    }

    public double getEvaluatedValue() {
        return this.evaluatedValue;
    }

    public void setDesiredValue(double value) {
        this.desiredValue = value;
    }

    public JPanel getOptionPanel() {
        return this.optionPanel;
    }

    protected void initCalculation() {
        int un = 0;
        while (un < this.nUnit) {
            this.units[un].initCalculation();
            ++un;
        }
    }

    public void moveUnitsToNearestInputs() {
        int un = 0;
        while (un < this.nUnit) {
            int m = Sets.findNearest(this.inputD, this.units[un].mean);
            System.arraycopy(this.inputD[m], 0, this.units[un].mean, 0, this.dim);
            ++un;
        }
    }

    protected int findNearestMean(double[] vec) {
        double diff;
        int m = 0;
        double minNorm = 0.0;
        int d = 0;
        while (d < this.dim) {
            diff = this.units[0].mean[d] - vec[d];
            minNorm += diff * diff;
            ++d;
        }
        int un = 1;
        while (un < this.nUnit) {
            double norm = 0.0;
            int d2 = 0;
            while (d2 < this.dim) {
                diff = this.units[un].mean[d2] - vec[d2];
                norm += diff * diff;
                ++d2;
            }
            if (norm < minNorm) {
                m = un;
                minNorm = norm;
            }
            ++un;
        }
        return m;
    }

    protected void findNearestMean(double[][] vec) {
        int in = 0;
        while (in < this.nInput) {
            double diff;
            int m = 0;
            double minNorm = 0.0;
            int d = 0;
            while (d < this.dim) {
                diff = this.units[0].mean[d] - vec[in][d];
                minNorm += diff * diff;
                ++d;
            }
            int un = 1;
            while (un < this.nUnit) {
                double norm = 0.0;
                int d2 = 0;
                while (d2 < this.dim) {
                    diff = this.units[un].mean[d2] - vec[in][d2];
                    norm += diff * diff;
                    ++d2;
                }
                if (norm < minNorm) {
                    m = un;
                    minNorm = norm;
                }
                ++un;
            }
            this.cluster[in] = m;
            ++in;
        }
    }

    public void resetEvaluatedValue() {
        this.evaluatedValue = Double.POSITIVE_INFINITY;
    }
}

