/*
 * Decompiled with CFR 0.152.
 */
package sos.image;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import sos.graphics.SOSGraphics;
import sos.image.ROI;

public class ROIRectangle
extends Rectangle
implements ROI,
SOSGraphics {
    private static final long serialVersionUID = -1356222839139636843L;
    private Rectangle clippingRect = new Rectangle();
    private Point startPoint;
    private boolean visible = false;
    private BasicStroke dash = new BasicStroke(1.0f, 0, 0, 2.0f, new float[]{2.0f, 2.0f}, 4.0f);

    public ROIRectangle() {
    }

    public ROIRectangle(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void draw(Graphics g) {
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.white);
            g2d.setStroke(this.dash);
            g2d.draw(this);
        }
    }

    public void handleMouseDragged(Point p) {
        int x = Math.min(this.startPoint.x, p.x);
        int y = Math.min(this.startPoint.y, p.y);
        int width = Math.abs(this.startPoint.x - p.x) + 1;
        int height = Math.abs(this.startPoint.y - p.y) + 1;
        this.setRect(x, y, width, height);
        this.clippingRect.setRect(x - 1, y - 1, width + 2, height + 2);
    }

    public void handleMousePressed(Point p) {
        this.startPoint = p;
        this.setLocation(p);
        this.setSize(1, 1);
    }

    public Rectangle getClippingRect() {
        return this.clippingRect;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

