/*
 * Decompiled with CFR 0.152.
 */
package sos.image;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import sos.colorspace.ColorVector;
import sos.image.ImagePixelMediator;
import sos.io.SOSImageIO;
import sos.process.NeighborFrame;
import sos.util.MinMaxInteger;

public class ImageInfo {
    private String fileName;
    private NeighborFrame neighborFrame = new NeighborFrame(1, 1);
    private int[] pixels;
    private int[] pixelsColorsTable = null;
    private int[] pixelsLabel = new int[1];
    private int[] intRGB;
    private int[] colorsHistogram;
    private int[][] colorsPixelsTable = null;
    private int colorSpaceType;
    private Image image;

    public ImageInfo() {
        this.pixelsColorsTable = new int[1];
    }

    public ImageInfo(BufferedImage img) {
        this();
        this.setImage(img);
    }

    public void setImage(Image img) {
        this.image = img;
        this.setSize(img.getWidth(null), img.getHeight(null));
        this.extractPixels(img);
    }

    private void extractPixels(Image img) {
        this.pixels = ImagePixelMediator.convertToPixels(img);
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public void setSize(int w, int h) {
        if (w != this.neighborFrame.width || h != this.neighborFrame.height) {
            this.neighborFrame = new NeighborFrame(w, h);
        }
        if (this.pixelsLabel.length != this.neighborFrame.size) {
            this.pixelsColorsTable = new int[this.neighborFrame.size];
            this.pixelsLabel = new int[this.neighborFrame.size];
        }
    }

    public int getWidth() {
        return this.neighborFrame.width;
    }

    public int getHeight() {
        return this.neighborFrame.height;
    }

    public int getImageSize() {
        return this.neighborFrame.size;
    }

    public void setName(String name) {
        this.fileName = name;
    }

    public final String getName() {
        return this.fileName;
    }

    public int getUsedColorNumber() {
        return this.intRGB.length;
    }

    public int[] getIntRGB() {
        return this.intRGB;
    }

    public int getIntRGB(int index) {
        return this.intRGB[index];
    }

    public int[] getPixelColorTable() {
        return this.pixelsColorsTable;
    }

    public int getPixelColorTable(int index) {
        return this.pixelsColorsTable[index];
    }

    public void setColor() {
        this.setColor(this.pixels);
    }

    public void setColor(int[] pixels) {
        this.intRGB = ColorVector.extractUsedColor(pixels);
        this.colorsHistogram = ColorVector.makeHistogram(pixels, this.intRGB, this.pixelsColorsTable);
    }

    public void setIntRGB(int[] rgb) {
        this.intRGB = rgb;
    }

    public void setColorHistogram(int[] h) {
        this.colorsHistogram = h;
    }

    public double[][] getRGB() {
        this.colorSpaceType = 0;
        double[][] input = new double[this.intRGB.length][3];
        ColorVector.getRGB(this.intRGB, input);
        return input;
    }

    public double[][] getLAB() {
        this.colorSpaceType = 1;
        double[][] input = new double[this.intRGB.length][3];
        ColorVector.getLAB(this.intRGB, input);
        return input;
    }

    public int[] getHistogram() {
        return this.colorsHistogram;
    }

    public NeighborFrame getNeighborFrame() {
        return this.neighborFrame;
    }

    public void setPixelsLabel(int[] colorLabel) {
        int pn = 0;
        while (pn < this.neighborFrame.size) {
            this.pixelsLabel[pn] = colorLabel[this.pixelsColorsTable[pn]];
            ++pn;
        }
    }

    public void setPixelsLabel(int index, int value) {
        this.pixelsLabel[index] = value;
    }

    public int[] getPixelsLabel() {
        return this.pixelsLabel;
    }

    public int getPixelsLabel(int index) {
        return this.pixelsLabel[index];
    }

    public void clearLabel() {
        int i = 0;
        while (i < this.pixelsLabel.length) {
            this.pixelsLabel[i] = -1;
            ++i;
        }
    }

    public int[][] getColorPixelTable() {
        if (this.colorsPixelsTable != null) {
            return this.colorsPixelsTable;
        }
        this.colorsPixelsTable = new int[this.intRGB.length][];
        int in = 0;
        while (in < this.intRGB.length) {
            this.colorsPixelsTable[in] = new int[this.colorsHistogram[in]];
            Arrays.fill(this.colorsPixelsTable[in], -1);
            ++in;
        }
        int pn = 0;
        while (pn < this.neighborFrame.size) {
            int index = this.pixelsColorsTable[pn];
            int i = 0;
            while (i < this.colorsPixelsTable[index].length) {
                if (this.colorsPixelsTable[index][i] == -1) {
                    this.colorsPixelsTable[index][i] = pn;
                    break;
                }
                ++i;
            }
            ++pn;
        }
        return this.colorsPixelsTable;
    }

    public int getColorSpaceType() {
        return this.colorSpaceType;
    }

    public int[] createClusterFromLabel(int nUnit) {
        int[] result = new int[this.intRGB.length];
        this.setClusterFromLabel(nUnit, result);
        return result;
    }

    public void setClusterFromLabel(int nUnit, int[] cluster) {
        int[][] nLabel = new int[this.intRGB.length][nUnit];
        int pn = 0;
        while (pn < this.neighborFrame.size) {
            int[] nArray = nLabel[this.pixelsColorsTable[pn]];
            int n = this.getPixelsLabel(pn);
            nArray[n] = nArray[n] + 1;
            ++pn;
        }
        MinMaxInteger mmi = new MinMaxInteger();
        int in = 0;
        while (in < this.intRGB.length) {
            mmi.compareMax(nLabel[in]);
            cluster[in] = mmi.getIndex();
            ++in;
        }
    }

    public Image getImage() {
        return this.image;
    }

    public Image createImage(int[] rgb) {
        int pn = 0;
        while (pn < this.pixels.length) {
            this.pixels[pn] = this.pixelsLabel[pn] >= 0 ? rgb[this.pixelsLabel[pn]] : 0;
            ++pn;
        }
        return ImagePixelMediator.convertToImage(this.pixels, this.getWidth(), this.getHeight());
    }

    public void setFile(File file) {
        BufferedImage img = SOSImageIO.readImage(file);
        this.setName(file.getName());
        this.setImage(img);
        this.setColor();
        this.clearLabel();
    }
}

