/*
 * Decompiled with CFR 0.152.
 */
package sos.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import sos.graphics.SOSGraphics;

public class GraphicsImage
implements SOSGraphics {
    private BufferedImage img;
    private Color backgroundColor = new Color(0, 0, 0, 0);
    private AffineTransform transform = new AffineTransform();
    private ArrayList<SOSGraphics> graphicObjects = new ArrayList();

    public void setSize(int width, int height) {
        this.img = new BufferedImage(width, height, 2);
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public void addGraphicObject(SOSGraphics graphicComponent) {
        this.graphicObjects.add(graphicComponent);
    }

    public void clearGraphicObject() {
        this.graphicObjects.clear();
    }

    protected void drawGraphicObjects() {
        if (this.graphicObjects.size() > 0) {
            Graphics2D g2d = (Graphics2D)this.img.getGraphics();
            g2d.setBackground(this.backgroundColor);
            g2d.clearRect(0, 0, this.img.getWidth(), this.img.getHeight());
            int i = 0;
            while (i < this.graphicObjects.size()) {
                this.graphicObjects.get(i).draw(g2d);
                ++i;
            }
        }
    }

    public void draw(Graphics g) {
        if (this.img != null) {
            this.drawGraphicObjects();
            Graphics2D g2d = (Graphics2D)g;
            g2d.drawImage(this.img, this.transform, null);
        }
    }
}

