/*
 * Decompiled with CFR 0.152.
 */
package sos.colorspace;

import sos.colorspace.SOSColorSpace;

public class CIEXYZ
extends SOSColorSpace {
    private static double[] temp = new double[3];

    public double[] fromRGB(int[] rgb) {
        int i = 0;
        while (i < rgb.length) {
            CIEXYZ.temp[i] = (double)rgb[i] / 255.0;
            ++i;
        }
        return this.RGBtoXYZ(temp);
    }

    public int[] toRGB(double[] value) {
        this.XYZtoRGB(value, temp);
        int[] result = new int[value.length];
        int i = 0;
        while (i < value.length) {
            result[i] = (int)(temp[i] * 255.0 + 0.5);
            ++i;
        }
        return result;
    }

    private void RGBtoXYZ(double[] rgb, double[] xyz) {
        xyz[0] = 0.4124 * rgb[0] + 0.3576 * rgb[1] + 0.1805 * rgb[2];
        xyz[1] = 0.2126 * rgb[0] + 0.7152 * rgb[1] + 0.0722 * rgb[2];
        xyz[2] = 0.0193 * rgb[0] + 0.1192 * rgb[1] + 0.9505 * rgb[2];
    }

    private double[] RGBtoXYZ(double[] rgb) {
        double[] xyz = new double[3];
        this.RGBtoXYZ(rgb, xyz);
        return xyz;
    }

    private void XYZtoRGB(double[] xyz, double[] rgb) {
        rgb[0] = 3.2406 * xyz[0] - 1.5372 * xyz[1] - 0.4986 * xyz[2];
        rgb[1] = -0.9689 * xyz[0] + 1.8758 * xyz[1] + 0.0415 * xyz[2];
        rgb[2] = 0.0557 * xyz[0] - 0.204 * xyz[1] + 1.057 * xyz[2];
    }
}

