/*
 * Decompiled with CFR 0.152.
 */
package sos.color;

import java.awt.Color;
import java.util.ArrayList;
import sos.color.ColorModel;
import sos.designPattern.observer.ConcreteSubject;
import sos.designPattern.observer.IObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorPanelModel
implements IObserver<ColorModel> {
    private ArrayList<ColorModel> listColorModel = new ArrayList();
    private String name;
    private ConcreteSubject<ColorModel> colorNumberStation;

    public ColorPanelModel() {
    }

    public ColorPanelModel(String arg) {
        this.name = arg;
    }

    public String toString() {
        return this.name;
    }

    public void clearColor() {
        int i = 0;
        while (i < this.listColorModel.size()) {
            this.listColorModel.get(i).setColor(Color.black);
            ++i;
        }
    }

    public void updateColor(int index, Color color) {
        this.listColorModel.get(index).setColor(color);
    }

    public void updateColor(int index, int[] data) {
        this.listColorModel.get(index).setColor(data);
    }

    public void updateColor(int[][] data) {
        int n = Math.min(data.length, this.listColorModel.size());
        int i = 0;
        while (i < n) {
            this.listColorModel.get(i).setColor(data[i]);
            ++i;
        }
    }

    public void updateColor(int[] dataInt) {
        int i = 0;
        while (i < dataInt.length) {
            this.listColorModel.get(i).setColor(dataInt[i]);
            ++i;
        }
    }

    public Color getColor(int index) {
        return this.listColorModel.get(index).getColor();
    }

    public Color[] getColor() {
        Color[] result = new Color[this.listColorModel.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getColor(i);
            ++i;
        }
        return result;
    }

    public int getColorInt(int index) {
        return this.getColor(index).getRGB();
    }

    public int[] getColorInt() {
        int[] array = new int[this.listColorModel.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = this.getColorInt(i);
            ++i;
        }
        return array;
    }

    public int[] getColorArray(int index) {
        return this.listColorModel.get(index).getColorArray();
    }

    public int[][] getColorArray() {
        int[][] array = new int[this.listColorModel.size()][];
        int i = 0;
        while (i < this.listColorModel.size()) {
            array[i] = this.getColorArray(i);
            ++i;
        }
        return array;
    }

    public String getColorString(int index) {
        return this.listColorModel.get(index).getColorString();
    }

    protected void remove(int index) {
        if (index < this.listColorModel.size()) {
            this.listColorModel.remove(index);
            this.colorNumberStation.inform(null);
        }
    }

    protected ColorModel add() {
        ColorModel model = new ColorModel();
        this.listColorModel.add(model);
        this.colorNumberStation.inform(model);
        return model;
    }

    protected ColorModel get(int index) {
        return this.listColorModel.get(index);
    }

    public int getColorNumber() {
        return this.listColorModel.size();
    }

    public void setColorNumber(int n) {
        int oldN = this.listColorModel.size();
        if (oldN == n) {
            return;
        }
        int diff = n - oldN;
        if (diff > 0) {
            int i = 0;
            while (i < diff) {
                this.add();
                ++i;
            }
        } else {
            int i = diff;
            while (i < 0) {
                this.remove(n);
                ++i;
            }
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void updateColor(Color[] color) {
        int n = Math.min(color.length, this.listColorModel.size());
        int i = 0;
        while (i < n) {
            this.listColorModel.get(i).setColor(color[i].getRGB());
            ++i;
        }
    }

    public void addObserver(IObserver<ColorModel> obj) {
        if (this.colorNumberStation == null) {
            this.colorNumberStation = new ConcreteSubject();
        }
        this.colorNumberStation.addObserver(obj);
    }

    @Override
    public void update(ColorModel arg) {
        if (arg == null) {
            this.remove(this.listColorModel.size() - 1);
        } else {
            this.add();
        }
    }
}

