/*
 * Decompiled with CFR 0.152.
 */
package sos.color;

import java.awt.Color;
import sos.designPattern.observer.ConcreteSubject;
import sos.designPattern.observer.IObserver;

public class ColorModel {
    private Color color = new Color(0, 0, 0);
    private int[] RGB = new int[3];
    private ConcreteSubject colorChangedStation = new ConcreteSubject();

    public Color getColor() {
        return this.color;
    }

    public int[] getColorArray() {
        return this.RGB;
    }

    public int getColorInt() {
        return this.color.getRGB();
    }

    public void setColor(int[] data) {
        if (data != null) {
            this.RGB = data;
            this.color = new Color(this.RGB[0], this.RGB[1], this.RGB[2]);
            this.colorChangedStation.inform(null);
        }
    }

    public void setColor(int data) {
        this.color = new Color(data);
        this.setRGB();
    }

    public void setColor(Color aColor) {
        if (this.color != null) {
            this.color = aColor;
            this.setRGB();
        }
    }

    private void setRGB() {
        this.RGB[0] = this.color.getRed();
        this.RGB[1] = this.color.getGreen();
        this.RGB[2] = this.color.getBlue();
        this.colorChangedStation.inform(null);
    }

    public String getColorString() {
        return "(" + this.RGB[0] + "," + this.RGB[1] + "," + this.RGB[2] + ")";
    }

    public void addObserver(IObserver observer) {
        this.colorChangedStation.addObserver(observer);
    }
}

