/*
 * Decompiled with CFR 0.152.
 */
package sos.canvas;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JPanel;
import sos.canvas.CanvasManager;
import sos.graphics.SOSGraphics;
import sos.image.ImageTransform;

public class JObjectCanvas
extends JPanel {
    protected CanvasManager manager = new CanvasManager();
    protected ImageTransform imageTransform = new ImageTransform();
    private ArrayList<SOSGraphics> graphicObjects = new ArrayList();
    private int oldX;
    private int oldY;

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.imageTransform.hasImage()) {
            this.imageTransform.drawImage(g);
        }
        this.drawGraphicObjects(g);
        g.dispose();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.manager.resized(width, height);
        if (this.imageTransform != null) {
            this.imageTransform.setDestSize(width, height);
            this.imageTransform.translateScreen(this.manager.deltaWidth, this.manager.deltaHeight);
        }
    }

    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.setPreferredSize(new Dimension(x, y));
    }

    public int getGrahicsObjectsNumber() {
        return this.graphicObjects.size();
    }

    public SOSGraphics getGraphicObject(int index) {
        return this.graphicObjects.get(index);
    }

    public void addGraphicObject(SOSGraphics graphicComponent) {
        this.graphicObjects.add(graphicComponent);
    }

    protected void drawGraphicObjects(Graphics g) {
        if (this.graphicObjects.size() > 0) {
            int i = 0;
            while (i < this.graphicObjects.size()) {
                this.graphicObjects.get(i).draw(g);
                ++i;
            }
        }
    }

    public void removeGraphicObject(SOSGraphics graphicComponent) {
        this.graphicObjects.remove(graphicComponent);
    }

    public void clearGraphicObject() {
        this.graphicObjects.clear();
    }

    public void setImage(Image img) {
        this.imageTransform.setDestSize(this.getWidth(), this.getHeight());
        this.imageTransform.setImage(img);
    }

    public BufferedImage getScreenImage() {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.imageTransform.drawImage(img.getGraphics());
        return img;
    }

    public void setImageTransform(ImageTransform imageTransform) {
        this.imageTransform = imageTransform;
    }

    public ImageTransform getImageTransform() {
        return this.imageTransform;
    }

    public void mouseClicked(MouseEvent evt) {
        int modifier = evt.getModifiers();
        double rate = 2.0;
        if ((modifier & 8) != 0 || (modifier & 4) != 0) {
            rate = 0.5;
        }
        this.getImageTransform().scaleImage(rate, evt.getX(), evt.getY());
    }

    public void mouseDragged(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        int dx = x - this.oldX;
        int dy = y - this.oldY;
        this.oldX = x;
        this.oldY = y;
        this.getImageTransform().translateScreen(dx, dy);
    }

    public void mousePressed(MouseEvent evt) {
        this.oldX = evt.getX();
        this.oldY = evt.getY();
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
        double ratio = 1.0 + (double)evt.getWheelRotation() * 0.05;
        this.getImageTransform().scaleImage(ratio);
    }

    public void removeGraphicObject(int index) {
        this.graphicObjects.remove(index);
    }
}

